/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.markdown;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.symphonyoss.symphony.messageml.elements.Bold;
import org.symphonyoss.symphony.messageml.elements.BulletList;
import org.symphonyoss.symphony.messageml.elements.CashTag;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.HashTag;
import org.symphonyoss.symphony.messageml.elements.Italic;
import org.symphonyoss.symphony.messageml.elements.LineBreak;
import org.symphonyoss.symphony.messageml.elements.ListItem;
import org.symphonyoss.symphony.messageml.elements.Mention;
import org.symphonyoss.symphony.messageml.elements.MessageML;
import org.symphonyoss.symphony.messageml.elements.Table;
import org.symphonyoss.symphony.messageml.elements.TableCell;
import org.symphonyoss.symphony.messageml.elements.TableRow;
import org.symphonyoss.symphony.messageml.elements.TextNode;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.EntityDelimiterProcessor;
import org.symphonyoss.symphony.messageml.markdown.nodes.KeywordNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.MentionNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableCellNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableRowNode;
import org.symphonyoss.symphony.messageml.util.IDataProvider;

public class MarkdownParser
extends AbstractVisitor {
    private static final Parser MARKDOWN_PARSER;
    private static final String INDEX = "index";
    private static final String INDEX_START = "indexStart";
    private static final String INDEX_END = "indexEnd";
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String TEXT = "text";
    private final IDataProvider dataProvider;
    private MessageML messageML;
    private Element parent;
    private int index;

    public MarkdownParser(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void visit(Document document) {
        this.messageML = new MessageML(FormatEnum.PRESENTATIONML, "2.0");
        this.parent = this.messageML;
        this.visitChildren((Node)document);
    }

    public void visit(Text text) {
        TextNode node = new TextNode(this.parent, text.getLiteral());
        this.parent.addChild(node);
        this.visitChildren((Node)text);
    }

    public void visit(HtmlInline tag) {
        TextNode node = new TextNode(this.parent, tag.getLiteral());
        this.parent.addChild(node);
        this.visitChildren((Node)tag);
    }

    public void visit(HardLineBreak hardLineBreak) {
        LineBreak node = new LineBreak(this.parent);
        this.parent.addChild(node);
        this.visitChildren((Node)hardLineBreak);
    }

    public void visit(Paragraph paragraph) {
        if (!(this.parent instanceof ListItem || this.parent instanceof MessageML && paragraph.getPrevious() == null)) {
            LineBreak node = new LineBreak(this.parent);
            this.parent.addChild(node);
        }
        this.visitChildren((Node)paragraph);
    }

    public void visit(Emphasis em) {
        Italic node = new Italic(this.parent);
        this.visitChildren(node, (Node)em);
    }

    public void visit(StrongEmphasis b) {
        Bold node = new Bold(this.parent);
        this.visitChildren(node, (Node)b);
    }

    public void visit(Link a) {
        try {
            org.symphonyoss.symphony.messageml.elements.Link node = new org.symphonyoss.symphony.messageml.elements.Link(this.parent, a.getDestination(), this.dataProvider);
            node.validate();
            this.visitChildren(node, (Node)a);
        }
        catch (InvalidInputException e) {
            TextNode node = new TextNode(this.parent, a.getDestination());
            this.visitChildren(node, (Node)a);
        }
    }

    public void visit(org.commonmark.node.BulletList ul) {
        BulletList node = new BulletList(this.parent);
        this.visitChildren(node, (Node)ul);
    }

    public void visit(OrderedList ol) {
        org.symphonyoss.symphony.messageml.elements.OrderedList node = new org.symphonyoss.symphony.messageml.elements.OrderedList(this.parent);
        this.visitChildren(node, (Node)ol);
    }

    public void visit(org.commonmark.node.ListItem li) {
        ListItem node = new ListItem(this.parent);
        this.visitChildren(node, (Node)li);
    }

    public void visit(FencedCodeBlock code) {
        if (code.getFenceChar() == '`' && code.getFenceLength() == 3) {
            org.symphonyoss.symphony.messageml.elements.Code node = new org.symphonyoss.symphony.messageml.elements.Code(this.parent);
            TextNode text = new TextNode((Element)node, code.getLiteral().trim());
            node.addChild(text);
            this.visitChildren(node, (Node)code);
        } else {
            String delimiter = StringUtils.repeat((char)code.getFenceChar(), (int)code.getFenceLength());
            Text node = new Text(delimiter + code.getLiteral().trim() + delimiter);
            this.visit(node);
        }
    }

    public void visit(Code code) {
        org.symphonyoss.symphony.messageml.elements.Code node = new org.symphonyoss.symphony.messageml.elements.Code(this.parent);
        TextNode text = new TextNode((Element)node, code.getLiteral().trim());
        node.addChild(text);
        this.visitChildren(node, (Node)code);
    }

    public void visit(CustomNode node) {
        if (node instanceof KeywordNode) {
            this.visit((KeywordNode)node);
        } else if (node instanceof MentionNode) {
            this.visit((MentionNode)node);
        }
    }

    public void visit(CustomBlock block) {
        if (block instanceof TableNode) {
            this.visit((TableNode)block);
        } else if (block instanceof TableRowNode) {
            this.visit((TableRowNode)block);
        } else if (block instanceof TableCellNode) {
            this.visit((TableCellNode)block);
        }
    }

    private void visit(KeywordNode keyword) {
        switch (keyword.getPrefix()) {
            case "#": {
                HashTag hashtag = new HashTag(this.parent, ++this.index, keyword.getText());
                this.visitChildren(hashtag, (Node)keyword);
                break;
            }
            case "$": {
                CashTag cashtag = new CashTag(this.parent, ++this.index, keyword.getText());
                this.visitChildren(cashtag, (Node)keyword);
            }
        }
    }

    private void visit(MentionNode mention) {
        try {
            Mention node = new Mention(this.parent, ++this.index, (Long)mention.getUid(), this.dataProvider);
            node.validate();
            this.visitChildren(node, (Node)mention);
        }
        catch (InvalidInputException e) {
            String text = (String)ObjectUtils.firstNonNull((Object[])new String[]{mention.getPrettyName(), mention.getScreenName(), mention.getEmail(), String.valueOf(mention.getUid())});
            TextNode node = new TextNode(this.parent, text);
            this.visitChildren(node, (Node)mention);
        }
    }

    private void visit(TableNode table) {
        Table node = new Table(this.parent);
        this.visitChildren(node, (Node)table);
    }

    private void visit(TableRowNode tr) {
        TableRow node = new TableRow(this.parent);
        this.visitChildren(node, (Node)tr);
    }

    private void visit(TableCellNode td) {
        TableCell node = new TableCell(this.parent);
        this.visitChildren(node, (Node)td);
    }

    private void visitChildren(Element element, Node node) {
        this.parent.addChild(element);
        this.parent = element;
        this.visitChildren(node);
        this.parent = element.getParent();
    }

    private String enrichMarkdown(String message, JsonNode entitiesNode, JsonNode mediaNode) throws InvalidInputException {
        TreeMap<Integer, JsonNode> entities = new TreeMap<Integer, JsonNode>();
        TreeMap<Integer, JsonNode> media = new TreeMap<Integer, JsonNode>();
        if (entitiesNode != null) {
            this.validateEntities(entitiesNode);
            for (JsonNode node : entitiesNode.findParents(INDEX_START)) {
                entities.put(node.get(INDEX_START).intValue(), node);
            }
        }
        if (mediaNode != null) {
            this.validateMedia(mediaNode);
            for (JsonNode node : mediaNode.findParents(INDEX)) {
                media.put(node.get(INDEX).intValue(), node.get(TEXT));
            }
        }
        int lastIndex = Math.max(!entities.isEmpty() ? (Integer)entities.lastKey() : 0, !media.isEmpty() ? (Integer)media.lastKey() : 0);
        if (message.length() <= lastIndex) {
            message = StringUtils.rightPad((String)message, (int)(lastIndex + 1));
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (entities.containsKey(i)) {
                JsonNode entity = (JsonNode)entities.get(i);
                String entityType = entity.get(TYPE).asText().toUpperCase();
                String id = entity.get(ID).asText();
                output.append('\u0091');
                output.append(entityType).append('\u0092');
                output.append(id);
                output.append('\u0091');
                int endIndex = entity.get(INDEX_END).intValue() - 1;
                i = Math.max(endIndex, i);
                continue;
            }
            if (media.containsKey(i)) {
                JsonNode table = (JsonNode)media.get(i);
                output.append('\u0091');
                output.append("TABLE").append('\u0092');
                for (JsonNode row : table) {
                    for (JsonNode cell : row) {
                        String text = cell.asText();
                        output.append(text).append('\u001e');
                    }
                    output.append('\u001d');
                }
                output.append('\u0091');
                output.append(c);
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    private void validateEntities(JsonNode data) throws InvalidInputException {
        for (JsonNode node : data.findParents(INDEX_START)) {
            for (String key : new String[]{INDEX_START, INDEX_END, ID, TYPE}) {
                if (!node.path(key).isMissingNode()) continue;
                throw new InvalidInputException("Required field \"" + key + "\" missing from the entity payload");
            }
            int startIndex = node.get(INDEX_START).intValue();
            int endIndex = node.get(INDEX_END).intValue();
            if (endIndex > startIndex) continue;
            throw new InvalidInputException(String.format("Invalid entity payload: %s (start index: %s, end index: %s)", node.get(ID).textValue(), startIndex, endIndex));
        }
    }

    private void validateMedia(JsonNode data) throws InvalidInputException {
        for (JsonNode node : data.findParents(INDEX)) {
            JsonNode text = node.path(TEXT);
            if (text.isMissingNode() || text.isArray() && text.get(0).isArray()) continue;
            throw new InvalidInputException(String.format("Invalid table payload: %s (index: %s)", text.asText(), node.get(INDEX)));
        }
    }

    public MessageML parse(String message, JsonNode entities, JsonNode media) throws InvalidInputException {
        this.index = 0;
        message = message.replace('\u00a0', ' ');
        String enriched = this.enrichMarkdown(message, entities, media);
        Node markdown = MARKDOWN_PARSER.parse(enriched);
        markdown.accept((Visitor)this);
        return this.messageML;
    }

    static {
        HashSet<Class<ListBlock>> enabledBlockTypes = new HashSet<Class<ListBlock>>();
        enabledBlockTypes.add(Heading.class);
        enabledBlockTypes.add(ThematicBreak.class);
        enabledBlockTypes.add(FencedCodeBlock.class);
        enabledBlockTypes.add(BlockQuote.class);
        enabledBlockTypes.add(ListBlock.class);
        MARKDOWN_PARSER = Parser.builder().enabledBlockTypes(enabledBlockTypes).customDelimiterProcessor((DelimiterProcessor)new EntityDelimiterProcessor()).build();
    }
}

