/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Node;

public interface SplittableElement {
    public static final String PRESENTATIONML_DIV_FLAG = "data-generated";

    default public String splittableAsPresentationML(XmlPrintStream out, MessageMLContext context) {
        TooltipableElement tooltipableElement;
        LabelableElement labelableElement;
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("class", String.format("%s-group", this.getElementId()));
        attributes.put(PRESENTATIONML_DIV_FLAG, Boolean.TRUE.toString());
        out.openElement("div", attributes);
        String id = String.format("%s-%s", this.getElementId(), context.generateShortId());
        if (this instanceof LabelableElement && (labelableElement = (LabelableElement)this).isLabel()) {
            out.printElement(labelableElement.getPresentationMLLabelTag(), this.getAttribute("label"), labelableElement.getLabelAttribute(id));
        }
        if (this instanceof TooltipableElement && (tooltipableElement = (TooltipableElement)this).isTooltip()) {
            out.openElement(tooltipableElement.getPresentationMLTooltipTag(), tooltipableElement.getTooltipAttributes(id));
            out.closeElement();
        }
        return id;
    }

    default public Set<String> splittableRemove() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this instanceof LabelableElement) {
            result.add("label");
        }
        if (this instanceof TooltipableElement) {
            result.add("title");
        }
        return result;
    }

    default public boolean isSplittableNodeComponent(Node item) {
        if (this instanceof LabelableElement && ((LabelableElement)this).isLabelNode(item)) {
            return true;
        }
        return this instanceof TooltipableElement && TooltipableElement.isTooltipNode(item);
    }

    default public void validateSplittable() throws InvalidInputException {
        if (this instanceof LabelableElement) {
            ((LabelableElement)this).validateLabel();
        }
        if (this instanceof TooltipableElement) {
            ((TooltipableElement)this).validateTooltip();
        }
    }

    default public boolean isSplittable() {
        if (this instanceof LabelableElement && ((LabelableElement)this).isLabel()) {
            return true;
        }
        return this instanceof TooltipableElement && ((TooltipableElement)this).isTooltip();
    }

    default public String getElementId() {
        if (this instanceof Element) {
            return ((Element)((Object)this)).getPresentationMLTag();
        }
        return "";
    }

    default public void fillAttributes(MessageMLParser parser, Node item, Map<String, String> attributes) throws InvalidInputException {
        Optional<Map<Class<? extends SplittableElement>, Pair<String, String>>> allSplittableValues;
        String id = this.getStringAttribute(item);
        Optional<Map<Class<? extends SplittableElement>, Map<String, String>>> allSplittableAttributes = parser.getAllSplittableAttributes(id);
        if (allSplittableAttributes.isPresent()) {
            for (Map<String, String> splittableAttributes : allSplittableAttributes.get().values()) {
                attributes.putAll(splittableAttributes);
            }
        }
        if ((allSplittableValues = parser.getAllSplittableValues(id)).isPresent()) {
            for (Pair<String, String> splittableValue : allSplittableValues.get().values()) {
                attributes.put((String)splittableValue.getKey(), (String)splittableValue.getValue());
            }
        }
    }

    default public void fillAttributes(MessageMLParser parser, Node item) throws InvalidInputException {
        this.fillAttributes(parser, item, this.getAttributes());
    }

    public String getAttribute(String var1);

    public Map<String, String> getAttributes();

    public String getStringAttribute(Node var1);
}

