/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TimezonePickerNode;
import org.symphonyoss.symphony.messageml.util.XMLAttribute;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class TimezonePicker
extends FormElement
implements LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "timezone-picker";
    private static final String VALUE_ATTR = "value";
    private static final String REQUIRED_ATTR = "required";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String DISABLED_TIMEZONE_ATTR = "disabled-timezone";
    private static final String NAME_PRESENTATION_ATTR = "data-name";
    private static final String VALUE_PRESENTATION_ATTR = "data-value";
    private static final String REQUIRED_PRESENTATION_ATTR = "data-required";
    private static final String PLACEHOLDER_PRESENTATION_ATTR = "data-placeholder";
    private static final String DISABLED_TIMEZONE_PRESENTATION_ATTR = "data-disabled-timezone";
    private static final int DISABLED_TIMEZONE_MAX_LENGTH = 1024;
    private static final String PRESENTATIONML_TAG = "div";
    private static final String CLASS_ATTR = "class";

    public TimezonePicker(Element parent, FormatEnum format) {
        super(parent, MESSAGEML_TAG, format);
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "value": 
            case "title": 
            case "label": 
            case "required": 
            case "placeholder": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "disabled-timezone": {
                if (this.format != FormatEnum.MESSAGEML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": 
            case "data-value": 
            case "data-name": 
            case "data-required": 
            case "data-placeholder": 
            case "data-disabled-timezone": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.assertAttributeNotBlank("name");
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, Arrays.asList("true", "false"));
        }
        if (this.getAttribute(VALUE_ATTR) != null && !this.getAttribute(VALUE_ATTR).isEmpty()) {
            this.assertTimezoneValid(VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        }
        this.assertAttributeMaxLength(DISABLED_TIMEZONE_ATTR, 1024);
        this.assertAttrDisabledTimezone(DISABLED_TIMEZONE_ATTR);
    }

    private void assertAttrDisabledTimezone(String attributeName) throws InvalidInputException {
        String disabledTimezones = this.getAttribute(attributeName);
        if (disabledTimezones == null) {
            return;
        }
        try {
            List timezones = (List)MAPPER.readValue(disabledTimezones, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            for (String timezone : timezones) {
                this.assertTimezoneValid(attributeName, timezone);
            }
        }
        catch (JsonProcessingException e) {
            throw new InvalidInputException(String.format("Error parsing json in attribute \"%s\". It should contain an array of Strings", attributeName), e);
        }
    }

    private void assertTimezoneValid(String attributeValue, String timezone) throws InvalidInputException {
        try {
            ZoneId.of(timezone);
        }
        catch (DateTimeException e) {
            throw new InvalidInputException(String.format("Attribute \"%s\" contains an invalid timezone: %s", attributeValue, timezone), e);
        }
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, Object> presentationAttrs = this.buildTimezonePickerInputAttributes();
        if (this.isSplittable()) {
            presentationAttrs.put("id", this.splittableAsPresentationML(out, context));
            this.innerAsPresentationML(out, presentationAttrs);
            out.closeElement();
        } else {
            this.innerAsPresentationML(out, presentationAttrs);
        }
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        this.putOneIfPresent(attributesMapBi, BiFields.TITLE.getValue(), "title");
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.putOneIfPresent(attributesMapBi, BiFields.PLACEHOLDER.getValue(), PLACEHOLDER_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.REQUIRED.getValue(), REQUIRED_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.DEFAULT.getValue(), VALUE_ATTR);
        this.computeAndPutValidationProperties(attributesMapBi);
        context.addItem(new BiItem(BiFields.TIMEZONE_PICKER.getValue(), attributesMapBi));
    }

    private void computeAndPutValidationProperties(Map<String, Object> attributesMapBi) {
        boolean validationOptions;
        boolean bl = validationOptions = this.getAttribute(DISABLED_TIMEZONE_ATTR) != null;
        if (validationOptions) {
            attributesMapBi.put(BiFields.VALIDATION_OPTIONS.getValue(), 1);
            attributesMapBi.put(BiFields.VALIDATION.getValue(), 1);
        }
    }

    @Override
    public Node asMarkdown() {
        return new TimezonePickerNode(this.getAttribute("label"), this.getAttribute("title"), this.getAttribute(PLACEHOLDER_ATTR));
    }

    private void innerAsPresentationML(XmlPrintStream out, Map<String, Object> presentationAttrs) {
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        out.closeElement();
    }

    private Map<String, Object> buildTimezonePickerInputAttributes() {
        LinkedHashMap<String, Object> presentationAttrs = new LinkedHashMap<String, Object>();
        presentationAttrs.put(CLASS_ATTR, MESSAGEML_TAG);
        presentationAttrs.put(NAME_PRESENTATION_ATTR, this.getAttribute("name"));
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(VALUE_PRESENTATION_ATTR, this.getAttribute(VALUE_ATTR));
        }
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PLACEHOLDER_PRESENTATION_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(DISABLED_TIMEZONE_ATTR) != null) {
            presentationAttrs.put(DISABLED_TIMEZONE_PRESENTATION_ATTR, this.convertJsonTimezoneToPresentationML(DISABLED_TIMEZONE_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(REQUIRED_PRESENTATION_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        return presentationAttrs;
    }

    private XMLAttribute convertJsonTimezoneToPresentationML(String attributeName) {
        try {
            List timezones = (List)MAPPER.readValue(this.getAttribute(attributeName), (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, String.class));
            String result = MAPPER.writeValueAsString((Object)timezones);
            return XMLAttribute.of(result, XMLAttribute.Format.JSON);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

