/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.api;

import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.agent.invoker.Pair;
import org.symphonyoss.symphony.agent.model.V5EventList;
import org.symphonyoss.symphony.agent.model.V5Firehose;
import org.symphonyoss.symphony.agent.model.V5FirehoseReadRequest;

public class FirehoseApi {
    private ApiClient apiClient;

    public FirehoseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FirehoseApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public V5Firehose v5FirehoseCreatePost(String sessionToken, String keyManagerToken) throws ApiException {
        Object localVarPostBody = null;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v5FirehoseCreatePost");
        }
        if (keyManagerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'keyManagerToken' when calling v5FirehoseCreatePost");
        }
        String localVarPath = "/v5/firehose/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        if (keyManagerToken != null) {
            localVarHeaderParams.put("keyManagerToken", this.apiClient.parameterToString(keyManagerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<V5Firehose> localVarReturnType = new GenericType<V5Firehose>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void v5FirehoseIdDeleteDelete(String sessionToken, String keyManagerToken, String id) throws ApiException {
        Object localVarPostBody = null;
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v5FirehoseIdDeleteDelete");
        }
        if (keyManagerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'keyManagerToken' when calling v5FirehoseIdDeleteDelete");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling v5FirehoseIdDeleteDelete");
        }
        String localVarPath = "/v5/firehose/{id}/delete".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        if (keyManagerToken != null) {
            localVarHeaderParams.put("keyManagerToken", this.apiClient.parameterToString(keyManagerToken));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public V5EventList v5FirehoseIdReadPost(String id, String sessionToken, String keyManagerToken, V5FirehoseReadRequest payload) throws ApiException {
        V5FirehoseReadRequest localVarPostBody = payload;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling v5FirehoseIdReadPost");
        }
        if (sessionToken == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionToken' when calling v5FirehoseIdReadPost");
        }
        if (keyManagerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'keyManagerToken' when calling v5FirehoseIdReadPost");
        }
        if (payload == null) {
            throw new ApiException(400, "Missing the required parameter 'payload' when calling v5FirehoseIdReadPost");
        }
        String localVarPath = "/v5/firehose/{id}/read".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sessionToken != null) {
            localVarHeaderParams.put("sessionToken", this.apiClient.parameterToString(sessionToken));
        }
        if (keyManagerToken != null) {
            localVarHeaderParams.put("keyManagerToken", this.apiClient.parameterToString(keyManagerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<V5EventList> localVarReturnType = new GenericType<V5EventList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

