/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.symphonyoss.symphony.agent.model.BaseMessage;

@ApiModel(description="A representation of a message sent by a user of Symphony.")
public class Message
extends BaseMessage {
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="fromUserId")
    private Long fromUserId = null;

    public Message message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Message text in MessageML")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Message fromUserId(Long fromUserId) {
        this.fromUserId = fromUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="the Symphony userId of the user who sent the message. This will be populated by the server (and actually ignored if included when sending a message).")
    public Long getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(Long fromUserId) {
        this.fromUserId = fromUserId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.message, message.message) && Objects.equals(this.fromUserId, message.fromUserId) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.message, this.fromUserId, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Message {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    fromUserId: ").append(this.toIndentedString(this.fromUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

