/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class MessageSearchQuery {
    @JsonProperty(value="text")
    private String text = null;
    @JsonProperty(value="streamId")
    private String streamId = null;
    @JsonProperty(value="streamType")
    private String streamType = null;
    @JsonProperty(value="author")
    private Long author = null;
    @JsonProperty(value="hashtag")
    private String hashtag = null;
    @JsonProperty(value="cashtag")
    private String cashtag = null;
    @JsonProperty(value="mention")
    private Long mention = null;
    @JsonProperty(value="signal")
    private String signal = null;
    @JsonProperty(value="fromDate")
    private Long fromDate = null;
    @JsonProperty(value="toDate")
    private Long toDate = null;

    public MessageSearchQuery text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Search for messages containing this text. Requires streamId to be specified.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public MessageSearchQuery streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @ApiModelProperty(value="Search for messages sent to this stream")
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public MessageSearchQuery streamType(String streamType) {
        this.streamType = streamType;
        return this;
    }

    @ApiModelProperty(value="Search for messages sent to this type of streams. Accepted values are CHAT, IM, MIM, ROOM, POST. ")
    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String streamType) {
        this.streamType = streamType;
    }

    public MessageSearchQuery author(Long author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(value="Search for messages sent by this user ID")
    public Long getAuthor() {
        return this.author;
    }

    public void setAuthor(Long author) {
        this.author = author;
    }

    public MessageSearchQuery hashtag(String hashtag) {
        this.hashtag = hashtag;
        return this;
    }

    @ApiModelProperty(value="Search for messages containing this hashtag")
    public String getHashtag() {
        return this.hashtag;
    }

    public void setHashtag(String hashtag) {
        this.hashtag = hashtag;
    }

    public MessageSearchQuery cashtag(String cashtag) {
        this.cashtag = cashtag;
        return this;
    }

    @ApiModelProperty(value="Search for messages containing this cashtag")
    public String getCashtag() {
        return this.cashtag;
    }

    public void setCashtag(String cashtag) {
        this.cashtag = cashtag;
    }

    public MessageSearchQuery mention(Long mention) {
        this.mention = mention;
        return this;
    }

    @ApiModelProperty(value="Search for messages mentioning this user ID")
    public Long getMention() {
        return this.mention;
    }

    public void setMention(Long mention) {
        this.mention = mention;
    }

    public MessageSearchQuery signal(String signal) {
        this.signal = signal;
        return this;
    }

    @ApiModelProperty(value="Search for messages matching this signal. Can only be combined with date filtering and paging parameters. ")
    public String getSignal() {
        return this.signal;
    }

    public void setSignal(String signal) {
        this.signal = signal;
    }

    public MessageSearchQuery fromDate(Long fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    @ApiModelProperty(value="Search for messages sent on or after this timestamp")
    public Long getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Long fromDate) {
        this.fromDate = fromDate;
    }

    public MessageSearchQuery toDate(Long toDate) {
        this.toDate = toDate;
        return this;
    }

    @ApiModelProperty(value="Search for messages sent before this timestamp")
    public Long getToDate() {
        return this.toDate;
    }

    public void setToDate(Long toDate) {
        this.toDate = toDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSearchQuery messageSearchQuery = (MessageSearchQuery)o;
        return Objects.equals(this.text, messageSearchQuery.text) && Objects.equals(this.streamId, messageSearchQuery.streamId) && Objects.equals(this.streamType, messageSearchQuery.streamType) && Objects.equals(this.author, messageSearchQuery.author) && Objects.equals(this.hashtag, messageSearchQuery.hashtag) && Objects.equals(this.cashtag, messageSearchQuery.cashtag) && Objects.equals(this.mention, messageSearchQuery.mention) && Objects.equals(this.signal, messageSearchQuery.signal) && Objects.equals(this.fromDate, messageSearchQuery.fromDate) && Objects.equals(this.toDate, messageSearchQuery.toDate);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.streamId, this.streamType, this.author, this.hashtag, this.cashtag, this.mention, this.signal, this.fromDate, this.toDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageSearchQuery {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("    streamType: ").append(this.toIndentedString(this.streamType)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    hashtag: ").append(this.toIndentedString(this.hashtag)).append("\n");
        sb.append("    cashtag: ").append(this.toIndentedString(this.cashtag)).append("\n");
        sb.append("    mention: ").append(this.toIndentedString(this.mention)).append("\n");
        sb.append("    signal: ").append(this.toIndentedString(this.signal)).append("\n");
        sb.append("    fromDate: ").append(this.toIndentedString(this.fromDate)).append("\n");
        sb.append("    toDate: ").append(this.toIndentedString(this.toDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

