/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A historic message to be imported into the system. The importing user must have the Content Management role. Also, the importing user must be a member of the conversation it is importing into. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. By design, imported messages do not stream to datafeed or firehose endpoints. ")
public class V2ImportedMessage {
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="format")
    private FormatEnum format = null;
    @JsonProperty(value="intendedMessageTimestamp")
    private Long intendedMessageTimestamp = null;
    @JsonProperty(value="intendedMessageFromUserId")
    private Long intendedMessageFromUserId = null;
    @JsonProperty(value="originatingSystemId")
    private String originatingSystemId = null;
    @JsonProperty(value="originalMessageId")
    private String originalMessageId = null;
    @JsonProperty(value="streamId")
    private String streamId = null;

    public V2ImportedMessage message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Message text in MessageML")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V2ImportedMessage format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(value="")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public V2ImportedMessage intendedMessageTimestamp(Long intendedMessageTimestamp) {
        this.intendedMessageTimestamp = intendedMessageTimestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp representing the time when the message was sent in the original system in milliseconds since Jan 1st 1970. ")
    public Long getIntendedMessageTimestamp() {
        return this.intendedMessageTimestamp;
    }

    public void setIntendedMessageTimestamp(Long intendedMessageTimestamp) {
        this.intendedMessageTimestamp = intendedMessageTimestamp;
    }

    public V2ImportedMessage intendedMessageFromUserId(Long intendedMessageFromUserId) {
        this.intendedMessageFromUserId = intendedMessageFromUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="The long integer userid of the Symphony user who you intend to show sent the message. ")
    public Long getIntendedMessageFromUserId() {
        return this.intendedMessageFromUserId;
    }

    public void setIntendedMessageFromUserId(Long intendedMessageFromUserId) {
        this.intendedMessageFromUserId = intendedMessageFromUserId;
    }

    public V2ImportedMessage originatingSystemId(String originatingSystemId) {
        this.originatingSystemId = originatingSystemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the system through which the message was originally sent. ")
    public String getOriginatingSystemId() {
        return this.originatingSystemId;
    }

    public void setOriginatingSystemId(String originatingSystemId) {
        this.originatingSystemId = originatingSystemId;
    }

    public V2ImportedMessage originalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the message in the original system. ")
    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public V2ImportedMessage streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2ImportedMessage v2ImportedMessage = (V2ImportedMessage)o;
        return Objects.equals(this.message, v2ImportedMessage.message) && Objects.equals((Object)this.format, (Object)v2ImportedMessage.format) && Objects.equals(this.intendedMessageTimestamp, v2ImportedMessage.intendedMessageTimestamp) && Objects.equals(this.intendedMessageFromUserId, v2ImportedMessage.intendedMessageFromUserId) && Objects.equals(this.originatingSystemId, v2ImportedMessage.originatingSystemId) && Objects.equals(this.originalMessageId, v2ImportedMessage.originalMessageId) && Objects.equals(this.streamId, v2ImportedMessage.streamId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.format, this.intendedMessageTimestamp, this.intendedMessageFromUserId, this.originatingSystemId, this.originalMessageId, this.streamId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2ImportedMessage {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    intendedMessageTimestamp: ").append(this.toIndentedString(this.intendedMessageTimestamp)).append("\n");
        sb.append("    intendedMessageFromUserId: ").append(this.toIndentedString(this.intendedMessageFromUserId)).append("\n");
        sb.append("    originatingSystemId: ").append(this.toIndentedString(this.originatingSystemId)).append("\n");
        sb.append("    originalMessageId: ").append(this.toIndentedString(this.originalMessageId)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        TEXT("TEXT"),
        MESSAGEML("MESSAGEML");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String text) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

