/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.agent.model.AttachmentInfo;
import org.symphonyoss.symphony.agent.model.V2BaseMessage;

@ApiModel(description="A representation of a message sent by a user of Symphony.")
public class V2Message
extends V2BaseMessage {
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="fromUserId")
    private Long fromUserId = null;
    @JsonProperty(value="attachments")
    private List<AttachmentInfo> attachments = null;

    public V2Message message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Message text in MessageML")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V2Message fromUserId(Long fromUserId) {
        this.fromUserId = fromUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="the Symphony userId of the user who sent the message. This will be populated by the server (and actually ignored if included when sending a message).")
    public Long getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(Long fromUserId) {
        this.fromUserId = fromUserId;
    }

    public V2Message attachments(List<AttachmentInfo> attachments) {
        this.attachments = attachments;
        return this;
    }

    public V2Message addAttachmentsItem(AttachmentInfo attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<AttachmentInfo>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<AttachmentInfo> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<AttachmentInfo> attachments) {
        this.attachments = attachments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2Message v2Message = (V2Message)o;
        return Objects.equals(this.message, v2Message.message) && Objects.equals(this.fromUserId, v2Message.fromUserId) && Objects.equals(this.attachments, v2Message.attachments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.message, this.fromUserId, this.attachments, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2Message {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    fromUserId: ").append(this.toIndentedString(this.fromUserId)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

