/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A historic message to be imported into the system. The importing user must have the Content Management role. Also, the importing user must be a member of the conversation it is importing into. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. By design, imported messages do not stream to datafeed or firehose endpoints. ")
public class V4ImportedMessage {
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="data")
    private String data = null;
    @JsonProperty(value="intendedMessageTimestamp")
    private Long intendedMessageTimestamp = null;
    @JsonProperty(value="intendedMessageFromUserId")
    private Long intendedMessageFromUserId = null;
    @JsonProperty(value="originatingSystemId")
    private String originatingSystemId = null;
    @JsonProperty(value="originalMessageId")
    private String originalMessageId = null;
    @JsonProperty(value="streamId")
    private String streamId = null;

    public V4ImportedMessage message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="Message text in MessageMLV2")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V4ImportedMessage data(String data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Entity data in EntityJSON")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public V4ImportedMessage intendedMessageTimestamp(Long intendedMessageTimestamp) {
        this.intendedMessageTimestamp = intendedMessageTimestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp representing the time when the message was sent in the original system in milliseconds since Jan 1st 1970. ")
    public Long getIntendedMessageTimestamp() {
        return this.intendedMessageTimestamp;
    }

    public void setIntendedMessageTimestamp(Long intendedMessageTimestamp) {
        this.intendedMessageTimestamp = intendedMessageTimestamp;
    }

    public V4ImportedMessage intendedMessageFromUserId(Long intendedMessageFromUserId) {
        this.intendedMessageFromUserId = intendedMessageFromUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="The long integer userid of the Symphony user who you intend to show sent the message. ")
    public Long getIntendedMessageFromUserId() {
        return this.intendedMessageFromUserId;
    }

    public void setIntendedMessageFromUserId(Long intendedMessageFromUserId) {
        this.intendedMessageFromUserId = intendedMessageFromUserId;
    }

    public V4ImportedMessage originatingSystemId(String originatingSystemId) {
        this.originatingSystemId = originatingSystemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the system through which the message was originally sent. ")
    public String getOriginatingSystemId() {
        return this.originatingSystemId;
    }

    public void setOriginatingSystemId(String originatingSystemId) {
        this.originatingSystemId = originatingSystemId;
    }

    public V4ImportedMessage originalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the message in the original system. ")
    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public V4ImportedMessage streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V4ImportedMessage v4ImportedMessage = (V4ImportedMessage)o;
        return Objects.equals(this.message, v4ImportedMessage.message) && Objects.equals(this.data, v4ImportedMessage.data) && Objects.equals(this.intendedMessageTimestamp, v4ImportedMessage.intendedMessageTimestamp) && Objects.equals(this.intendedMessageFromUserId, v4ImportedMessage.intendedMessageFromUserId) && Objects.equals(this.originatingSystemId, v4ImportedMessage.originatingSystemId) && Objects.equals(this.originalMessageId, v4ImportedMessage.originalMessageId) && Objects.equals(this.streamId, v4ImportedMessage.streamId);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.data, this.intendedMessageTimestamp, this.intendedMessageFromUserId, this.originatingSystemId, this.originalMessageId, this.streamId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V4ImportedMessage {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    intendedMessageTimestamp: ").append(this.toIndentedString(this.intendedMessageTimestamp)).append("\n");
        sb.append("    intendedMessageFromUserId: ").append(this.toIndentedString(this.intendedMessageFromUserId)).append("\n");
        sb.append("    originatingSystemId: ").append(this.toIndentedString(this.originatingSystemId)).append("\n");
        sb.append("    originalMessageId: ").append(this.toIndentedString(this.originalMessageId)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

