/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.agent.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.symphonyoss.symphony.agent.model.V4AttachmentInfo;
import org.symphonyoss.symphony.agent.model.V4Stream;
import org.symphonyoss.symphony.agent.model.V4User;

@ApiModel(description="A representation of a message sent by a user of Symphony")
public class V4Message {
    @JsonProperty(value="messageId")
    private String messageId = null;
    @JsonProperty(value="timestamp")
    private Long timestamp = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="data")
    private String data = null;
    @JsonProperty(value="attachments")
    private List<V4AttachmentInfo> attachments = null;
    @JsonProperty(value="user")
    private V4User user = null;
    @JsonProperty(value="stream")
    private V4Stream stream = null;
    @JsonProperty(value="externalRecipients")
    private Boolean externalRecipients = null;
    @JsonProperty(value="diagnostic")
    private String diagnostic = null;

    public V4Message messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(value="Id of the message")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public V4Message timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="Timestamp of the message in milliseconds since Jan 1 1970")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public V4Message message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Message content in MessageMLV2")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V4Message data(String data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Message data in EntityJSON")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public V4Message attachments(List<V4AttachmentInfo> attachments) {
        this.attachments = attachments;
        return this;
    }

    public V4Message addAttachmentsItem(V4AttachmentInfo attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<V4AttachmentInfo>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Message attachments")
    public List<V4AttachmentInfo> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<V4AttachmentInfo> attachments) {
        this.attachments = attachments;
    }

    public V4Message user(V4User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="")
    public V4User getUser() {
        return this.user;
    }

    public void setUser(V4User user) {
        this.user = user;
    }

    public V4Message stream(V4Stream stream) {
        this.stream = stream;
        return this;
    }

    @ApiModelProperty(value="")
    public V4Stream getStream() {
        return this.stream;
    }

    public void setStream(V4Stream stream) {
        this.stream = stream;
    }

    public V4Message externalRecipients(Boolean externalRecipients) {
        this.externalRecipients = externalRecipients;
        return this;
    }

    @ApiModelProperty(value="Indicates if the message have external recipients. Only present on real time messaging.")
    public Boolean getExternalRecipients() {
        return this.externalRecipients;
    }

    public void setExternalRecipients(Boolean externalRecipients) {
        this.externalRecipients = externalRecipients;
    }

    public V4Message diagnostic(String diagnostic) {
        this.diagnostic = diagnostic;
        return this;
    }

    @ApiModelProperty(value="Details if event failed to parse for any reason.  The contents of this field may not be useful, depending on the nature of the error. Only present when error occurs. ")
    public String getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(String diagnostic) {
        this.diagnostic = diagnostic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V4Message v4Message = (V4Message)o;
        return Objects.equals(this.messageId, v4Message.messageId) && Objects.equals(this.timestamp, v4Message.timestamp) && Objects.equals(this.message, v4Message.message) && Objects.equals(this.data, v4Message.data) && Objects.equals(this.attachments, v4Message.attachments) && Objects.equals(this.user, v4Message.user) && Objects.equals(this.stream, v4Message.stream) && Objects.equals(this.externalRecipients, v4Message.externalRecipients) && Objects.equals(this.diagnostic, v4Message.diagnostic);
    }

    public int hashCode() {
        return Objects.hash(this.messageId, this.timestamp, this.message, this.data, this.attachments, this.user, this.stream, this.externalRecipients, this.diagnostic);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V4Message {\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    stream: ").append(this.toIndentedString(this.stream)).append("\n");
        sb.append("    externalRecipients: ").append(this.toIndentedString(this.externalRecipients)).append("\n");
        sb.append("    diagnostic: ").append(this.toIndentedString(this.diagnostic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

