/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.ProgramFault;

public class SymphonyClientConfig {
    private static Logger log = LoggerFactory.getLogger(SymphonyClientConfig.class);
    private Properties config = new Properties();
    private boolean initialized;

    public SymphonyClientConfig() {
    }

    public SymphonyClientConfig(boolean load) {
        if (load) {
            this.load();
        }
    }

    public SymphonyClientConfig(String configFile) {
        this.set(SymphonyClientConfigID.SYMPHONY_CONFIG_FILE, configFile);
        this.load();
    }

    public void load() throws ProgramFault {
        String configFile = this.get(SymphonyClientConfigID.SYMPHONY_CONFIG_FILE);
        if (configFile != null) {
            this.upsertProperties(configFile);
        }
        StringBuilder s = null;
        for (SymphonyClientConfigID id : SymphonyClientConfigID.values()) {
            String v = this.get(id);
            if (v != null) {
                log.debug("{} = {}", (Object)id.getPropName(), (Object)v);
                continue;
            }
            if (!id.isCore()) continue;
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(",\n");
            }
            s.append((Object)id);
        }
        if (s != null) {
            throw new ProgramFault("The following required properties are undefined:\n" + s.toString());
        }
        this.initialized = true;
    }

    public String get(SymphonyClientConfigID id) {
        String value = this.config.getProperty(id.getPropName());
        if (value == null) {
            value = System.getProperty(id.getPropName());
        }
        if (value == null) {
            value = System.getenv(id.getEnvName());
        }
        if (value == null && id.getAltName() != null) {
            value = System.getProperty(id.getAltName());
        }
        return value;
    }

    public String get(SymphonyClientConfigID id, String defaultValue) {
        String value = this.get(id);
        return value != null ? value : defaultValue;
    }

    public String getRequired(SymphonyClientConfigID id) {
        String value = this.get(id);
        if (value == null) {
            throw new ProgramFault("Required config parameter \"" + (Object)((Object)id) + "\" is undefined.");
        }
        return value;
    }

    public String get(String id) {
        String value = this.config.getProperty(id);
        if (value == null) {
            value = System.getProperty(SymphonyClientConfigID.toPropName(id));
        }
        if (value == null) {
            value = System.getenv(SymphonyClientConfigID.toEnvName(id));
        }
        return value;
    }

    public String getRequired(String id) {
        String value = this.get(id);
        if (value == null) {
            throw new ProgramFault("Required config parameter \"" + id + "\" is undefined.");
        }
        return value;
    }

    public void set(SymphonyClientConfigID id, String value) {
        this.config.setProperty(id.getPropName(), value);
    }

    public void set(String property, String value) {
        this.config.setProperty(property, value);
    }

    public void upsertProperties(String propertiesFile) throws ProgramFault {
        Properties properties = this.loadProperties(propertiesFile);
        if (this.config == null) {
            this.config = properties;
        } else {
            this.config.putAll((Map<?, ?>)properties);
        }
    }

    private Properties loadProperties(String propertiesFile) throws ProgramFault {
        Properties properties = new Properties();
        if (propertiesFile != null) {
            try (FileReader reader = new FileReader(propertiesFile);){
                properties.load(reader);
            }
            catch (FileNotFoundException e) {
                throw new ProgramFault("Config file \"" + propertiesFile + "\" not found");
            }
            catch (IOException e) {
                throw new ProgramFault("Config file \"" + propertiesFile + "\" cannot be built", e);
            }
        }
        return properties;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

