/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client;

import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;

public class SymphonyClientConfigBuilder {
    private SymphonyClientConfigBuilder() {
        throw new RuntimeException("This class should not be instantiated.  Use the newBuilder method to get started.");
    }

    public static SessionAuthUrlStep newBuilder() {
        return new Steps();
    }

    private static class Steps
    implements SessionAuthUrlStep,
    KeyAuthUrlStep,
    PodUrlStep,
    AgentUrlStep,
    TrustStoreStep,
    UserCredsStep,
    BuildStep {
        private String sessionAuthUrl = null;
        private String keyAuthUrl = null;
        private String podUrl = null;
        private String agentUrl = null;
        private String trustStoreFilename = null;
        private char[] trustStorePassword = null;
        private String userEmail = null;
        private String userCertFilename = null;
        private char[] userCertPassword = null;
        private String receiverEmail = null;
        private boolean servicesEnabled = true;
        private boolean jmxHealthCheckEnabled = true;

        private Steps() {
        }

        @Override
        public KeyAuthUrlStep withSessionAuthUrl(String sessionAuthUrl) {
            this.sessionAuthUrl = sessionAuthUrl;
            return this;
        }

        @Override
        public PodUrlStep withKeyAuthUrl(String keyAuthUrl) {
            this.keyAuthUrl = keyAuthUrl;
            return this;
        }

        @Override
        public AgentUrlStep withPodUrl(String podUrl) {
            this.podUrl = podUrl;
            return this;
        }

        @Override
        public TrustStoreStep withAgentUrl(String agentUrl) {
            this.agentUrl = agentUrl;
            return this;
        }

        @Override
        public UserCredsStep withTrustStore(String trustStoreFilename, char[] trustStorePassword) {
            this.trustStoreFilename = trustStoreFilename;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        @Override
        public BuildStep withUserCreds(String userEmail, String userCertFilename, char[] userCertPassword) {
            this.userEmail = userEmail;
            this.userCertFilename = userCertFilename;
            this.userCertPassword = userCertPassword;
            return this;
        }

        @Override
        public BuildStep withReceiverEmail(String receiverEmail) {
            this.receiverEmail = receiverEmail;
            return this;
        }

        @Override
        public BuildStep withServices(boolean enabled) {
            this.servicesEnabled = enabled;
            return this;
        }

        @Override
        public BuildStep withJMXHealthcheck(boolean enabled) {
            this.jmxHealthCheckEnabled = enabled;
            return this;
        }

        @Override
        public SymphonyClientConfig build() {
            SymphonyClientConfig result = new SymphonyClientConfig();
            result.set(SymphonyClientConfigID.SESSIONAUTH_URL, this.sessionAuthUrl);
            result.set(SymphonyClientConfigID.KEYAUTH_URL, this.keyAuthUrl);
            result.set(SymphonyClientConfigID.POD_URL, this.podUrl);
            result.set(SymphonyClientConfigID.AGENT_URL, this.agentUrl);
            result.set(SymphonyClientConfigID.TRUSTSTORE_FILE, this.trustStoreFilename);
            result.set(SymphonyClientConfigID.TRUSTSTORE_PASSWORD, new String(this.trustStorePassword));
            result.set(SymphonyClientConfigID.USER_EMAIL, this.userEmail);
            result.set(SymphonyClientConfigID.USER_CERT_FILE, this.userCertFilename);
            result.set(SymphonyClientConfigID.USER_CERT_PASSWORD, new String(this.userCertPassword));
            result.set(SymphonyClientConfigID.RECEIVER_EMAIL, this.receiverEmail);
            result.set(SymphonyClientConfigID.DISABLE_SERVICES, String.valueOf(!this.servicesEnabled));
            result.set(SymphonyClientConfigID.HEALTHCHECK_JMX_ENABLED, String.valueOf(this.jmxHealthCheckEnabled));
            return result;
        }
    }

    public static interface BuildStep {
        public BuildStep withReceiverEmail(String var1);

        public BuildStep withServices(boolean var1);

        public BuildStep withJMXHealthcheck(boolean var1);

        public SymphonyClientConfig build();
    }

    public static interface UserCredsStep {
        public BuildStep withUserCreds(String var1, String var2, char[] var3);
    }

    public static interface TrustStoreStep {
        public UserCredsStep withTrustStore(String var1, char[] var2);
    }

    public static interface AgentUrlStep {
        public TrustStoreStep withAgentUrl(String var1);
    }

    public static interface PodUrlStep {
        public AgentUrlStep withPodUrl(String var1);
    }

    public static interface KeyAuthUrlStep {
        public PodUrlStep withKeyAuthUrl(String var1);
    }

    public static interface SessionAuthUrlStep {
        public KeyAuthUrlStep withSessionAuthUrl(String var1);
    }
}

