/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client;

public enum SymphonyClientConfigID {
    SYMPHONY_CONFIG_FILE(false),
    SESSIONAUTH_URL,
    KEYAUTH_URL,
    POD_URL,
    AGENT_URL,
    TRUSTSTORE_FILE("javax.net.ssl.trustStore", false),
    TRUSTSTORE_PASSWORD("javax.net.ssl.trustStorePassword", false),
    USER_CERT_FILE("javax.net.ssl.keyStore"),
    USER_CERT_PASSWORD("javax.net.ssl.keyStorePassword"),
    USER_EMAIL,
    RECEIVER_EMAIL(false),
    DISABLE_SERVICES(false),
    HEALTHCHECK_JMX_ENABLED(false);

    private final String altName;
    private final String propName;
    private final boolean core;

    private SymphonyClientConfigID() {
        this(null, true);
    }

    private SymphonyClientConfigID(String altName) {
        this(altName, true);
    }

    private SymphonyClientConfigID(boolean core) {
        this(null, core);
    }

    private SymphonyClientConfigID(String altName, boolean core) {
        this.altName = altName;
        this.propName = SymphonyClientConfigID.toPropName(this.name());
        this.core = core;
    }

    public static String toPropName(String name) {
        return name.toLowerCase().replaceAll("_", ".");
    }

    public static String toEnvName(String name) {
        return name.toUpperCase().replaceAll("\\.", "_");
    }

    public String getAltName() {
        return this.altName;
    }

    public String getPropName() {
        return this.propName;
    }

    public String getEnvName() {
        return this.name();
    }

    public boolean isCore() {
        return this.core;
    }

    public String toString() {
        if (this.altName == null) {
            return this.getPropName();
        }
        return this.getPropName() + " (or " + this.getAltName() + ")";
    }
}

