/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.InitException;
import org.symphonyoss.client.exceptions.NetworkException;
import org.symphonyoss.client.impl.CustomHttpClient;
import org.symphonyoss.client.impl.SymphonyBasicClient;
import org.symphonyoss.symphony.clients.model.ApiVersion;

public class SymphonyClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SymphonyClientFactory.class);

    public static SymphonyClient getClient(TYPE type) {
        return type.toString().equals(ApiVersion.V4.toString()) ? new SymphonyBasicClient(ApiVersion.V4) : new SymphonyBasicClient();
    }

    public static SymphonyClient getClient(TYPE type, SymphonyClientConfig config) {
        try {
            SymphonyClient symClient = SymphonyClientFactory.getClient(type);
            logger.debug("{} {}", (Object)config.get(SymphonyClientConfigID.SESSIONAUTH_URL), (Object)config.get(SymphonyClientConfigID.KEYAUTH_URL));
            try {
                symClient.setDefaultHttpClient(CustomHttpClient.getDefaultHttpClient(config));
            }
            catch (Exception e) {
                logger.error("Failed to create custom http client", (Throwable)e);
                return null;
            }
            symClient.init(symClient.getDefaultHttpClient(), config);
            return symClient;
        }
        catch (NetworkException ae) {
            logger.error(ae.getMessage(), (Throwable)ae);
        }
        catch (InitException e) {
            logger.error("error", (Throwable)e);
        }
        return null;
    }

    public static enum TYPE {
        BASIC,
        V4;

    }
}

