/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.ai;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.ai.AiAction;
import org.symphonyoss.client.ai.AiPermission;
import org.symphonyoss.client.ai.AiResponseSequence;
import org.symphonyoss.client.util.MlMessageParser;
import org.symphonyoss.symphony.clients.model.SymMessage;

public class AiCommand {
    private final Logger logger = LoggerFactory.getLogger(AiCommand.class);
    private String command;
    private int numArguments;
    private String[] prefixRequirements = new String[]{""};
    private String[] arguments = new String[0];
    private String usage;
    private Set<AiAction> actions = new LinkedHashSet<AiAction>();
    private Set<AiPermission> permissions = new HashSet<AiPermission>();

    public AiCommand(String command, int numArguments, String usage) {
        this.setCommand(command);
        this.setNumArguments(numArguments);
        this.setUsage(usage);
    }

    public boolean isCommand(String[] chunks) {
        String[] checkCommand = this.command.split("\\s+");
        if (chunks.length - checkCommand.length + 1 <= this.numArguments) {
            return false;
        }
        for (int commandIndex = 0; commandIndex < checkCommand.length; ++commandIndex) {
            if (chunks[commandIndex].trim().equalsIgnoreCase(checkCommand[commandIndex].trim())) continue;
            return false;
        }
        for (int chunkIndex = checkCommand.length; chunkIndex < this.numArguments + checkCommand.length; ++chunkIndex) {
            if (chunks[chunkIndex].startsWith(this.prefixRequirements[chunkIndex - checkCommand.length])) continue;
            return false;
        }
        return true;
    }

    public String toMLCommand() {
        StringBuilder toML = new StringBuilder();
        toML.append("    <b>");
        toML.append(this.command);
        toML.append("</b> ");
        for (int index = 0; index < this.numArguments; ++index) {
            toML.append(this.prefixRequirements[index]);
            toML.append(this.arguments[index]);
            toML.append("     (");
            toML.append(this.usage);
            toML.append(")");
        }
        toML.append("<br/>");
        return toML.toString();
    }

    public boolean userIsPermitted(Long userID) {
        for (AiPermission permission : this.permissions) {
            if (permission.userHasPermission(userID)) continue;
            return false;
        }
        return true;
    }

    public Set<AiResponseSequence> getResponses(MlMessageParser mlMessageParser, SymMessage message) {
        LinkedHashSet<AiResponseSequence> responses = new LinkedHashSet<AiResponseSequence>();
        for (AiAction action : this.getActions()) {
            responses.add(action.respond(mlMessageParser, message, this));
        }
        return responses;
    }

    public void resizePrefixesArguments() {
        int index;
        String[] resize = new String[this.numArguments];
        for (index = 0; index < this.prefixRequirements.length && index < this.numArguments; ++index) {
            resize[index] = this.prefixRequirements[index];
            if (resize[index] != null) continue;
            resize[index] = "";
        }
        this.prefixRequirements = resize;
        resize = new String[this.numArguments];
        for (index = 0; index < this.arguments.length && index < this.numArguments; ++index) {
            resize[index] = this.arguments[index];
            if (resize[index] != null) continue;
            resize[index] = "";
        }
        this.arguments = resize;
    }

    public int getNumArguments() {
        return this.numArguments;
    }

    public void setNumArguments(int numArguments) {
        this.numArguments = numArguments;
        this.resizePrefixesArguments();
    }

    public void setPrefixRequirement(int argumentIndex, String requirement) {
        if (argumentIndex > this.numArguments) {
            if (this.logger != null) {
                this.logger.debug("Could not add prefix requirement {}, not enough arguments.", (Object)requirement);
            }
            return;
        }
        this.prefixRequirements[argumentIndex] = requirement;
    }

    public void setAllPrefixRequirements(String[] prefixRequirements) {
        this.prefixRequirements = prefixRequirements;
    }

    public String getPrefixRequirement(int argumentIndex) {
        if (this.prefixRequirements.length > argumentIndex) {
            return this.prefixRequirements[argumentIndex];
        }
        return null;
    }

    public void setArgument(int argumentIndex, String holder) {
        if (argumentIndex > this.numArguments) {
            if (this.logger != null) {
                this.logger.debug("Could not add place holder {}, not enough arguments.", (Object)holder);
            }
            return;
        }
        this.arguments[argumentIndex] = holder;
    }

    public void setAllArguments(String[] placeHolders) {
        this.arguments = placeHolders;
    }

    public String getArguments(int argumentIndex) {
        if (this.arguments.length < argumentIndex) {
            return this.arguments[argumentIndex];
        }
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Set<AiPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<AiPermission> permissions) {
        this.permissions = permissions;
    }

    public Set<AiAction> getActions() {
        return this.actions;
    }

    public void setActions(Set<AiAction> actions) {
        this.actions = actions;
    }

    public void addPermission(AiPermission permission) {
        this.permissions.add(permission);
    }

    public void addAction(AiAction action) {
        this.actions.add(action);
    }

    public void removePermission(AiPermission permission) {
        this.permissions.remove(permission);
    }

    public void removeAction(AiAction action) {
        this.actions.remove(action);
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }
}

