/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.ai;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.ai.AiCommand;
import org.symphonyoss.client.ai.AiLastCommand;
import org.symphonyoss.client.ai.AiResponder;
import org.symphonyoss.client.ai.utils.AiSpellParser;
import org.symphonyoss.client.model.Chat;
import org.symphonyoss.client.services.ChatListener;
import org.symphonyoss.client.util.MlMessageParser;
import org.symphonyoss.symphony.clients.model.SymMessage;

public class AiCommandListener
implements ChatListener {
    private static final Logger logger = LoggerFactory.getLogger(AiCommandListener.class);
    private static final LinkedHashMap<String, HashSet<AiCommandListener>> listeners = new LinkedHashMap();
    private SymMessage lastAnsweredMessage;
    private final SymphonyClient symClient;
    private final ArrayList<AiCommand> activeCommands = new ArrayList();
    private final ConcurrentHashMap<String, AiLastCommand> lastResponse = new ConcurrentHashMap();
    private final AiResponder aiResponder;

    public AiCommandListener(SymphonyClient symClient) {
        this.symClient = symClient;
        this.aiResponder = new AiResponder(symClient);
    }

    public static boolean isCommand(SymMessage message, SymphonyClient symClient) {
        logger.debug("Received message for response.");
        try {
            MlMessageParser mlMessageParser = new MlMessageParser(symClient);
            mlMessageParser.parseMessage(message.getMessage());
            String[] chunks = mlMessageParser.getTextChunks();
            return chunks[0].charAt(0) == '/';
        }
        catch (Exception e) {
            logger.error("Could not parse message {}", (Object)message.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public void onChatMessage(SymMessage message) {
        if (message == null || message.getFromUserId() == null) {
            logger.warn("Received null message. Ignoring.");
            return;
        }
        logger.debug("Received message for response.");
        try {
            MlMessageParser mlMessageParser = new MlMessageParser(this.symClient);
            message.setMessage(message.getMessage().replace("\u00a0", " "));
            mlMessageParser.parseMessage(message.getMessage().trim());
            String[] chunks = mlMessageParser.getTextChunks();
            if (chunks[0].charAt(0) == '/') {
                mlMessageParser.parseMessage(message.getMessage().replaceFirst(">/", ">"));
                chunks = mlMessageParser.getTextChunks();
                this.processMessage(mlMessageParser, chunks, message);
            }
        }
        catch (Exception e) {
            logger.error("Could not parse message {}", (Object)message.getMessage(), (Object)e);
        }
    }

    private boolean isBestResponse(MlMessageParser mlMessageParser, String[] chunks, SymMessage message) {
        if (this.hasResponse(mlMessageParser, chunks, message)) {
            return true;
        }
        if (listeners.get(message.getStreamId()) != null) {
            for (AiCommandListener aiCommandListener : listeners.get(message.getStreamId())) {
                if (aiCommandListener == this || !aiCommandListener.hasResponse(mlMessageParser, chunks, message)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void processMessage(MlMessageParser mlMessageParser, String[] chunks, SymMessage message) {
        if (this.activeCommands.isEmpty()) {
            if (logger != null) {
                logger.warn("There are no active commands added to the listener. Ignoring process.");
            }
            return;
        }
        this.lastAnsweredMessage = message;
        for (AiCommand command : this.activeCommands) {
            if (command.isCommand(chunks) && command.userIsPermitted(message.getFromUserId())) {
                this.aiResponder.respond(command.getResponses(mlMessageParser, message), message.getStreamId());
                this.lastResponse.put(message.getId(), new AiLastCommand(mlMessageParser, command));
                return;
            }
            if (!command.isCommand(chunks)) continue;
            this.aiResponder.sendNoPermission(message);
            return;
        }
        if (!this.equalsRunLastCommand(mlMessageParser, message) && !this.canSuggest(chunks)) {
            this.aiResponder.sendUsage(message, mlMessageParser, this.activeCommands);
        } else if (!this.equalsRunLastCommand(mlMessageParser, message)) {
            AiLastCommand lastCommand = AiSpellParser.parse(this.activeCommands, chunks, this.symClient, 0.5);
            if (lastCommand != null) {
                this.aiResponder.sendSuggestionMessage(lastCommand, message);
                this.lastResponse.put(message.getFromUserId().toString(), lastCommand);
            }
        } else {
            AiLastCommand lastBotResponse = this.lastResponse.get(message.getFromUserId().toString());
            this.aiResponder.respondToEachUserWith(lastBotResponse.getAiCommand().getResponses(lastBotResponse.getMlMessageParser(), message));
        }
    }

    private boolean hasResponse(MlMessageParser mlMessageParser, String[] chunks, SymMessage message) {
        for (AiCommand command : this.activeCommands) {
            if (command.isCommand(chunks) && command.userIsPermitted(message.getFromUserId())) {
                return true;
            }
            if (!command.isCommand(chunks)) continue;
            return false;
        }
        return (this.equalsRunLastCommand(mlMessageParser, message) || this.canSuggest(chunks)) && this.equalsRunLastCommand(mlMessageParser, message);
    }

    private boolean equalsRunLastCommand(MlMessageParser mlMessageParser, SymMessage message) {
        return mlMessageParser.getText().trim().equalsIgnoreCase("Run Last") && this.lastResponse.get(message.getFromUserId().toString()) != null;
    }

    private boolean canSuggest(String[] chunks) {
        return AiSpellParser.canParse(this.activeCommands, chunks, 0.5);
    }

    public void listenOn(Chat chat) {
        if (chat != null) {
            if (listeners.containsKey(chat.getStream().getStreamId())) {
                listeners.get(chat.getStream().getStreamId()).add(this);
            } else {
                HashSet<AiCommandListener> newChat = new HashSet<AiCommandListener>();
                newChat.add(this);
                listeners.put(chat.getStream().getStreamId(), newChat);
            }
            chat.addListener(this);
        }
    }

    public void stopListening(Chat chat) {
        if (chat != null) {
            chat.removeListener(this);
            if (chat.getStream() != null && chat.getStream().getStreamId() != null) {
                if (listeners.containsKey(chat.getStream().getStreamId()) && listeners.get(chat.getStream().getStreamId()).contains(this)) {
                    listeners.get(chat.getStream().getStreamId()).remove(this);
                }
            } else {
                this.logChatError(chat, new NullPointerException());
            }
        } else {
            this.logChatError(null, new NullPointerException());
        }
    }

    private void logChatError(Chat chat, Exception e) {
        if (logger != null) {
            if (chat == null) {
                logger.error("Ignored method call. Chat was null value.", (Throwable)e);
            } else if (chat.getStream() == null) {
                logger.error("Could not put stream in push hash. Chat stream was null value.", (Throwable)e);
            } else if (chat.getStream().getStreamId() == null) {
                logger.error("Could not put stream in push hash. Chat stream id was null value.", (Throwable)e);
            }
        }
    }

    public ArrayList<AiCommand> getActiveCommands() {
        return this.activeCommands;
    }

    public boolean addCommand(AiCommand command) {
        if (this.activeCommands.contains(command)) {
            return false;
        }
        this.activeCommands.add(command);
        return true;
    }

    public boolean removeCommand(AiCommand command) {
        if (!this.activeCommands.contains(command)) {
            return false;
        }
        this.activeCommands.remove(command);
        return true;
    }

    public SymphonyClient getSymClient() {
        return this.symClient;
    }

    public SymMessage getLastAnsweredMessage() {
        return this.lastAnsweredMessage;
    }
}

