/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.ai;

import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.ai.AiCommand;
import org.symphonyoss.client.ai.AiLastCommand;
import org.symphonyoss.client.ai.AiResponse;
import org.symphonyoss.client.ai.AiResponseSequence;
import org.symphonyoss.client.ai.utils.Messenger;
import org.symphonyoss.client.common.AiConstants;
import org.symphonyoss.client.common.MLTypes;
import org.symphonyoss.client.exceptions.MessagesException;
import org.symphonyoss.client.util.MlMessageParser;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.clients.model.SymUser;

public class AiResponder {
    private final Logger logger = LoggerFactory.getLogger(AiResponder.class);
    private SymphonyClient symClient;

    public AiResponder(SymphonyClient symClient) {
        this.symClient = symClient;
    }

    public void sendMessage(String message, Long userID, SymphonyClient symClient) {
        SymUser symUser = new SymUser();
        symUser.setId(userID);
        try {
            this.sendMessage(message, symClient.getStreamsClient().getStream(symUser), symClient);
        }
        catch (Exception e) {
            this.logger.error("Error sending message", (Throwable)e);
        }
    }

    public void sendMessage(String message, SymStream stream, SymphonyClient symClient) {
        SymMessage userMessage = new SymMessage();
        userMessage.setMessageText(message);
        this.logger.debug("Sending message ..." + message);
        try {
            symClient.getMessagesClient().sendMessage(stream, userMessage);
        }
        catch (MessagesException e) {
            this.logger.error("API exception with POD while sending a message", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Unknown Exception while sending a message", (Throwable)e);
        }
    }

    public void sendMessage(SymMessage message, SymStream stream, SymphonyClient symClient) {
        this.logger.debug("Sending message ..." + message.getMessageText());
        try {
            symClient.getMessagesClient().sendMessage(stream, message);
        }
        catch (MessagesException e) {
            this.logger.error("API exception with POD while sending a message", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Unknown Exception while sending a message", (Throwable)e);
        }
    }

    public void respondToEachUserWith(Set<AiResponseSequence> responseLists) {
        System.out.println("Responding to each user...");
        for (AiResponseSequence list : responseLists) {
            if (list == null) continue;
            for (AiResponse response : list.getAiResponseSet()) {
                for (SymUser symUser : response.getSymUsers()) {
                    this.sendMessage(response.getMessage(), symUser.getId(), this.symClient);
                }
            }
        }
    }

    public void respond(Set<AiResponseSequence> responseLists, String streamId) {
        for (AiResponseSequence list : responseLists) {
            if (list == null) continue;
            for (AiResponse response : list.getAiResponseSet()) {
                SymStream stream = new SymStream();
                stream.setStreamId(streamId);
                this.sendMessage(response.getMessage(), stream, this.symClient);
            }
        }
    }

    public void sendSuggestionMessage(AiLastCommand suggestion, SymMessage message) {
        this.sendMessage("Did you mean " + (Object)((Object)MLTypes.START_BOLD) + suggestion.getMlMessageParser().getText() + (Object)((Object)MLTypes.END_BOLD) + AiConstants.USE_SUGGESTION, message.getFromUserId(), this.symClient);
    }

    public void sendUsage(SymMessage message, MlMessageParser mlMessageParser, ArrayList<AiCommand> activeCommands) {
        StringBuilder usage = new StringBuilder();
        usage.append(mlMessageParser.getText());
        usage.append(" is not a command or wrong # of arguments.");
        usage.append((Object)MLTypes.BREAK);
        usage.append((Object)MLTypes.START_BOLD);
        usage.append("Check the usage:");
        usage.append((Object)MLTypes.END_BOLD);
        usage.append((Object)MLTypes.BREAK);
        for (AiCommand command : activeCommands) {
            if (!command.userIsPermitted(message.getFromUserId())) continue;
            usage.append(command.toMLCommand());
        }
        this.sendMessage(usage.toString(), message.getFromUserId(), this.symClient);
    }

    public void sendNoPermission(SymMessage message) {
        Messenger.sendMessage("Sorry, you do not have permission to use that command.", message, this.symClient);
    }

    public SymphonyClient getSymClient() {
        return this.symClient;
    }

    public void setSymClient(SymphonyClient symClient) {
        this.symClient = symClient;
    }
}

