/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.ai.utils;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.ai.AiCommand;
import org.symphonyoss.client.ai.AiLastCommand;
import org.symphonyoss.client.common.MLTypes;
import org.symphonyoss.client.util.MlMessageParser;

public class AiSpellParser {
    private static final Logger logger = LoggerFactory.getLogger(AiSpellParser.class);

    public static boolean canParse(ArrayList<AiCommand> commands, String[] chunks, double closenessFactor) {
        for (AiCommand response : commands) {
            if (chunks.length <= response.getNumArguments()) continue;
            int likeness = 0;
            String[] checkCommand = response.getCommand().split("\\s+");
            for (int commandIndex = 0; commandIndex < checkCommand.length && commandIndex < chunks.length; ++commandIndex) {
                if (!AiSpellParser.isCloseTo(chunks[commandIndex].trim(), checkCommand[commandIndex].trim(), closenessFactor)) continue;
                ++likeness;
            }
            int possibleArguments = chunks.length - likeness;
            if (possibleArguments < response.getNumArguments() || !(closenessFactor <= (double)likeness / (double)checkCommand.length)) continue;
            return true;
        }
        return false;
    }

    public static AiLastCommand parse(ArrayList<AiCommand> commands, String[] chunks, SymphonyClient symClient, double closenessFactor) {
        for (AiCommand response : commands) {
            if (chunks.length < response.getNumArguments()) continue;
            int likeness = 0;
            String[] checkCommand = response.getCommand().split("\\s+");
            for (int commandIndex = 0; commandIndex < checkCommand.length && commandIndex < chunks.length; ++commandIndex) {
                if (!AiSpellParser.isCloseTo(chunks[commandIndex].trim(), checkCommand[commandIndex].trim(), closenessFactor)) continue;
                ++likeness;
            }
            int possibleArguments = chunks.length - likeness;
            if (possibleArguments < response.getNumArguments() || !(closenessFactor <= (double)likeness / (double)checkCommand.length)) continue;
            String[] arguments = new String[response.getNumArguments()];
            for (int index = 0; index < response.getNumArguments(); ++index) {
                arguments[index] = chunks[chunks.length - 1 - index];
            }
            StringBuilder fullCommand = new StringBuilder();
            fullCommand.append(response.getCommand());
            fullCommand.append(" ");
            for (int index = arguments.length - 1; index >= 0; --index) {
                fullCommand.append(response.getPrefixRequirement(arguments.length - 1 - index));
                fullCommand.append(arguments[index]);
                fullCommand.append(" ");
            }
            MlMessageParser mlMessageParser = new MlMessageParser(symClient);
            try {
                mlMessageParser.parseMessage((Object)((Object)MLTypes.START_ML) + fullCommand.toString() + (Object)((Object)MLTypes.END_ML));
            }
            catch (Exception e) {
                logger.error("While parsing message", (Throwable)e);
            }
            return new AiLastCommand(mlMessageParser, response);
        }
        return null;
    }

    private static boolean isCloseTo(String input1, String input2, double closenessFactor) {
        String smaller;
        String larger;
        int likeness = 0;
        if (input1.length() > input2.length()) {
            larger = input1;
            smaller = input2;
        } else {
            larger = input2;
            smaller = input1;
        }
        for (int index = 0; index < larger.length(); ++index) {
            if (!smaller.contains(larger.substring(index, index + 1))) continue;
            ++likeness;
        }
        return closenessFactor < (double)likeness / (double)larger.length();
    }
}

