/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.ai.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.MessagesException;
import org.symphonyoss.client.exceptions.StreamsException;
import org.symphonyoss.client.model.Chat;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.pod.model.Stream;
import org.symphonyoss.symphony.pod.model.UserIdList;

public class Messenger {
    private static final Logger logger = LoggerFactory.getLogger(Messenger.class);

    public static void sendMessage(String message, Long userID, SymphonyClient symClient) {
        SymMessage userMessage = new SymMessage();
        userMessage.setMessageText(message);
        UserIdList list = new UserIdList();
        list.add((Object)userID);
        try {
            symClient.getMessagesClient().sendMessage(symClient.getStreamsClient().getStream(list), userMessage);
        }
        catch (MessagesException e) {
            logger.error("API exception when communicating with POD while sending message", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unknown exception when communicating with POD while sending message", (Throwable)e);
        }
    }

    public static void sendMessage(String message, String email, SymphonyClient symClient) {
        SymMessage userMessage = new SymMessage();
        userMessage.setMessageText(message);
        try {
            symClient.getMessageService().sendMessage(email, userMessage);
        }
        catch (MessagesException e) {
            logger.error("API exception when communicating with POD while sending message", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unknown exception when communicating with POD while sending message", (Throwable)e);
        }
    }

    public static void sendMessage(String message, SymMessage refMes, SymphonyClient symClient) {
        SymMessage userMessage = new SymMessage();
        userMessage.setMessageText(message);
        Stream stream = new Stream();
        stream.setId(refMes.getStreamId());
        try {
            symClient.getMessagesClient().sendMessage(stream, userMessage);
        }
        catch (MessagesException e) {
            logger.error("API exception when communicating with POD while sending message", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unknown exception when communicating with POD while sending message", (Throwable)e);
        }
    }

    public static void sendMessage(String message, Chat chat, SymphonyClient symClient) {
        SymMessage userMessage = new SymMessage();
        userMessage.setMessageText(message);
        try {
            symClient.getMessageService().sendMessage(chat, userMessage);
        }
        catch (MessagesException e) {
            logger.error("API exception when communicating with POD while sending message", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unknown exception when communicating with POD while sending message", (Throwable)e);
        }
    }

    public static Chat getChat(Long userID, SymphonyClient symClient) {
        UserIdList list = new UserIdList();
        list.add((Object)userID);
        try {
            SymStream stream = symClient.getStreamsClient().getStream(list);
            if (stream.getStreamId() != null) {
                return symClient.getChatService().getChatByStream(stream.getStreamId());
            }
        }
        catch (StreamsException e) {
            logger.error("API exception when communicating with POD while retrieving stream", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unknown exception when communicating with POD while retrieving stream", (Throwable)e);
        }
        return null;
    }
}

