/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.exceptions;

import org.symphonyoss.client.exceptions.NetworkException;

public class RestException
extends NetworkException {
    private static final long serialVersionUID = 1L;
    private final int httpStatus;

    public RestException(String message, String endpoint, int httpStatus) {
        super(message, endpoint);
        this.httpStatus = httpStatus;
    }

    public RestException(String endpoint, int httpStatus, Throwable cause) {
        super(endpoint, cause);
        this.httpStatus = httpStatus;
    }

    public RestException(String message, String endpoint, int httpStatus, Throwable cause) {
        super(message, endpoint, cause);
        this.httpStatus = httpStatus;
    }

    public RestException(String message, RestException cause) {
        super(message, cause.getEndpoint(), cause);
        this.httpStatus = cause.getHttpStatus();
    }

    public RestException(RestException cause) {
        super(cause.getEndpoint(), cause);
        this.httpStatus = cause.getHttpStatus();
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\nendpoint " + this.getEndpoint() + "\nhttpStatus " + this.httpStatus;
    }
}

