/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.impl;

import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.NetworkException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.clients.AuthenticationClient;

public class AuthRefreshTask
extends TimerTask {
    private final Logger logger = LoggerFactory.getLogger(AuthRefreshTask.class);
    private final SymphonyClient symClient;

    public AuthRefreshTask(SymphonyClient symClient) {
        this.symClient = symClient;
    }

    @Override
    public void run() {
        this.runTask();
    }

    public SymAuth runTask() {
        SymAuth symAuth = null;
        try {
            AuthenticationClient authClient;
            if (this.symClient.getSymAuth() != null && this.symClient.getSymAuth().getHttpClient() != null) {
                authClient = new AuthenticationClient(this.symClient.getSymAuth().getSessionUrl(), this.symClient.getSymAuth().getKeyUrl(), this.symClient.getSymAuth().getHttpClient());
            } else {
                authClient = new AuthenticationClient(this.symClient.getSymAuth().getSessionUrl(), this.symClient.getSymAuth().getKeyUrl());
                authClient.setKeystores(this.symClient.getSymAuth().getServerTruststore(), this.symClient.getSymAuth().getServerTruststorePassword(), this.symClient.getSymAuth().getClientKeystore(), this.symClient.getSymAuth().getClientKeystorePassword());
            }
            symAuth = authClient.authenticate();
            this.symClient.getSymAuth().setKeyToken(symAuth.getKeyToken());
            this.symClient.getSymAuth().setSessionToken(symAuth.getSessionToken());
            this.logger.info("Successfully refreshed SymAuth tokens...");
        }
        catch (NetworkException e) {
            this.logger.error("Unable to refresh SymAuth keys...", (Throwable)e);
        }
        return symAuth;
    }
}

