/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.symphony.pod.invoker.JSON;

public class CustomHttpClient {
    public static Client getClient(String clientKeyStore, String clientKeyStorePass) throws Exception {
        KeyStore cks = KeyStore.getInstance("PKCS12");
        CustomHttpClient.loadKeyStore(cks, clientKeyStore, clientKeyStorePass);
        return ClientBuilder.newBuilder().keyStore(cks, clientKeyStorePass.toCharArray()).build();
    }

    public static Client getClient(String clientKeyStore, String clientKeyStorePass, ClientConfig clientConfig) throws Exception {
        KeyStore cks = KeyStore.getInstance("PKCS12");
        CustomHttpClient.loadKeyStore(cks, clientKeyStore, clientKeyStorePass);
        return ClientBuilder.newBuilder().keyStore(cks, clientKeyStorePass.toCharArray()).withConfig((Configuration)clientConfig).build();
    }

    public static Client getClient(String clientKeyStore, String clientKeyStorePass, String trustStore, String trustStorePass) throws Exception {
        KeyStore cks = KeyStore.getInstance("PKCS12");
        KeyStore tks = KeyStore.getInstance("JKS");
        CustomHttpClient.loadKeyStore(cks, clientKeyStore, clientKeyStorePass);
        CustomHttpClient.loadKeyStore(tks, trustStore, trustStorePass);
        return ClientBuilder.newBuilder().keyStore(cks, clientKeyStorePass.toCharArray()).trustStore(tks).build();
    }

    public static Client getClient(String clientKeyStore, String clientKeyStorePass, String trustStore, String trustStorePass, ClientConfig clientConfig) throws Exception {
        KeyStore cks = KeyStore.getInstance("PKCS12");
        KeyStore tks = KeyStore.getInstance("JKS");
        CustomHttpClient.loadKeyStore(cks, clientKeyStore, clientKeyStorePass);
        CustomHttpClient.loadKeyStore(tks, trustStore, trustStorePass);
        return CustomHttpClient.getClient(cks, clientKeyStorePass, tks, trustStorePass, clientConfig);
    }

    public static Client getClient(InputStream clientKeyStore, String clientKeyStorePass, InputStream trustStore, String trustStorePass, ClientConfig clientConfig) throws Exception {
        KeyStore cks = KeyStore.getInstance("PKCS12");
        KeyStore tks = KeyStore.getInstance("JKS");
        CustomHttpClient.loadKeyStore(cks, clientKeyStore, clientKeyStorePass);
        CustomHttpClient.loadKeyStore(tks, trustStore, trustStorePass);
        return CustomHttpClient.getClient(cks, clientKeyStorePass, tks, trustStorePass, clientConfig);
    }

    public static Client getClient(KeyStore clientKeyStore, String clientKeyStorePass, KeyStore trustStore, String trustStorePass, ClientConfig clientConfig) throws Exception {
        return ClientBuilder.newBuilder().keyStore(clientKeyStore, clientKeyStorePass.toCharArray()).trustStore(trustStore).withConfig((Configuration)clientConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(KeyStore ks, String ksFile, String ksPass) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(ksFile);
            CustomHttpClient.loadKeyStore(ks, fis, ksPass);
        }
    }

    private static void loadKeyStore(KeyStore ks, InputStream ksInputStream, String ksPass) throws Exception {
        ks.load(ksInputStream, ksPass.toCharArray());
    }

    public static Client getDefaultHttpClient(SymphonyClientConfig config) throws Exception {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register((Object)new JSON());
        clientConfig.register(JacksonFeature.class);
        Client httpClient = config.get(SymphonyClientConfigID.TRUSTSTORE_FILE) != null ? CustomHttpClient.getClient(config.get(SymphonyClientConfigID.USER_CERT_FILE), config.get(SymphonyClientConfigID.USER_CERT_PASSWORD), config.get(SymphonyClientConfigID.TRUSTSTORE_FILE), config.get(SymphonyClientConfigID.TRUSTSTORE_PASSWORD), clientConfig) : CustomHttpClient.getClient(config.get(SymphonyClientConfigID.USER_CERT_FILE), config.get(SymphonyClientConfigID.USER_CERT_PASSWORD), clientConfig);
        return httpClient;
    }
}

