/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.CacheType;
import org.symphonyoss.client.services.SymUserCache;
import org.symphonyoss.symphony.clients.model.SymUser;

public class DefaultUserCache
implements SymUserCache {
    LoadingCache<Long, SymUser> symUserById;
    LoadingCache<String, SymUser> symUserByEmail;
    LoadingCache<String, SymUser> symUserByName;
    LoadingCache<String, Set<SymUser>> symUserByStream;
    SymphonyClient symClient;
    private final Logger logger = LoggerFactory.getLogger(DefaultUserCache.class);

    public DefaultUserCache(SymphonyClient symClient) {
        this.symClient = symClient;
        this.symUserById = CacheBuilder.newBuilder().expireAfterAccess(new Long(System.getProperty("symusers.cache.accessedexpiry", "86400")).longValue(), TimeUnit.SECONDS).build((CacheLoader)new UidUserLoader());
        this.symUserByEmail = CacheBuilder.newBuilder().expireAfterAccess(new Long(System.getProperty("symusers.cache.accessedexpiry", "86400")).longValue(), TimeUnit.SECONDS).build((CacheLoader)new EmailUserLoader());
        this.symUserByName = CacheBuilder.newBuilder().expireAfterAccess(new Long(System.getProperty("symusers.cache.accessedexpiry", "86400")).longValue(), TimeUnit.SECONDS).build((CacheLoader)new NameUserLoader());
        this.symUserByStream = CacheBuilder.newBuilder().expireAfterAccess(new Long(System.getProperty("symusers.cache.accessedexpiry", "86400")).longValue(), TimeUnit.SECONDS).build((CacheLoader)new UserStreamLoader());
        this.logger.debug("Initialized default SymUser cache");
    }

    @Override
    public void setSymphonyClient(SymphonyClient symphonyClient) {
        this.symClient = symphonyClient;
    }

    @Override
    public SymUser getUserById(Long uid) throws UsersClientException {
        try {
            return (SymUser)this.symUserById.get((Object)uid);
        }
        catch (ExecutionException exc) {
            throw new UsersClientException("Cannot load user from cache by id", exc);
        }
    }

    @Override
    public SymUser getUserByName(String name) throws UsersClientException {
        try {
            return (SymUser)this.symUserByName.get((Object)name);
        }
        catch (ExecutionException exc) {
            this.logger.error("Exception loading user from cache by name", (Throwable)exc);
            throw new UsersClientException("Cannot load user from cache by naem", exc);
        }
    }

    @Override
    public Set<SymUser> getUsersByStream(String streamId) throws UsersClientException {
        try {
            this.logger.debug("Looking up user in name cache :" + streamId);
            return (Set)this.symUserByStream.get((Object)streamId);
        }
        catch (ExecutionException exc) {
            throw new UsersClientException("Cannot load users from cache by stream", exc);
        }
    }

    @Override
    public SymUser getUserByEmail(String email) throws UsersClientException {
        try {
            return (SymUser)this.symUserByEmail.get((Object)email);
        }
        catch (ExecutionException exc) {
            throw new UsersClientException("Cannot load user from cache by email", exc);
        }
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.USER;
    }

    @Override
    public void setCacheType(CacheType cacheType) {
    }

    private class UserStreamLoader
    extends CacheLoader<String, Set<SymUser>> {
        private UserStreamLoader() {
        }

        public Set<SymUser> load(String key) throws Exception {
            Set<SymUser> symUsers = DefaultUserCache.this.symClient.getUsersClient().getUsersFromStream(key);
            if (symUsers != null) {
                DefaultUserCache.this.symUserByStream.put((Object)key, symUsers);
                return symUsers;
            }
            throw new RuntimeException("cannot find Symphony users by stream " + key);
        }
    }

    private class NameUserLoader
    extends CacheLoader<String, SymUser> {
        private NameUserLoader() {
        }

        public SymUser load(String key) throws Exception {
            SymUser user;
            if (key != null) {
                key = key.toLowerCase();
            }
            if ((user = DefaultUserCache.this.symClient.getUsersClient().getUserFromName(key)) != null) {
                if (user.getEmailAddress() != null) {
                    DefaultUserCache.this.symUserByEmail.put((Object)user.getEmailAddress().toLowerCase(), (Object)user);
                }
                if (user.getId() != null) {
                    DefaultUserCache.this.symUserById.put((Object)user.getId(), (Object)user);
                }
                if (user.getUsername() != null) {
                    DefaultUserCache.this.symUserByName.put((Object)user.getUsername(), (Object)user);
                }
                return user;
            }
            throw new RuntimeException("cannot find Symphony user by name " + key);
        }
    }

    private class UidUserLoader
    extends CacheLoader<Long, SymUser> {
        private UidUserLoader() {
        }

        public SymUser load(Long key) throws Exception {
            SymUser user = DefaultUserCache.this.symClient.getUsersClient().getUserFromId(key);
            if (user != null) {
                if (user.getEmailAddress() != null) {
                    DefaultUserCache.this.symUserByEmail.put((Object)user.getEmailAddress().toLowerCase(), (Object)user);
                }
                if (user.getId() != null) {
                    DefaultUserCache.this.symUserById.put((Object)user.getId(), (Object)user);
                }
                if (user.getUsername() != null) {
                    DefaultUserCache.this.symUserByName.put((Object)user.getUsername(), (Object)user);
                }
                return user;
            }
            throw new RuntimeException("cannot find Symphony user by ID " + key);
        }
    }

    private class EmailUserLoader
    extends CacheLoader<String, SymUser> {
        private EmailUserLoader() {
        }

        public SymUser load(String key) throws Exception {
            SymUser user;
            if (key != null) {
                key = key.toLowerCase();
            }
            if ((user = DefaultUserCache.this.symClient.getUsersClient().getUserFromEmail(key)) != null) {
                if (user.getEmailAddress() != null) {
                    DefaultUserCache.this.symUserByEmail.put((Object)user.getEmailAddress().toLowerCase(), (Object)user);
                }
                if (user.getId() != null) {
                    DefaultUserCache.this.symUserById.put((Object)user.getId(), (Object)user);
                }
                if (user.getUsername() != null) {
                    DefaultUserCache.this.symUserByName.put((Object)user.getUsername(), (Object)user);
                }
                return user;
            }
            throw new RuntimeException("cannot find Symphony user by email " + key);
        }
    }
}

