/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.impl;

import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.AuthenticationException;
import org.symphonyoss.client.exceptions.InitException;
import org.symphonyoss.client.exceptions.SymCacheException;
import org.symphonyoss.client.exceptions.SymException;
import org.symphonyoss.client.impl.AuthRefreshTask;
import org.symphonyoss.client.impl.CustomHttpClient;
import org.symphonyoss.client.impl.DefaultUserCache;
import org.symphonyoss.client.model.CacheType;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.client.services.ChatService;
import org.symphonyoss.client.services.MessageService;
import org.symphonyoss.client.services.PresenceService;
import org.symphonyoss.client.services.RoomService;
import org.symphonyoss.client.services.SymCache;
import org.symphonyoss.client.services.SymUserCache;
import org.symphonyoss.symphony.clients.AttachmentsClient;
import org.symphonyoss.symphony.clients.AttachmentsFactory;
import org.symphonyoss.symphony.clients.AuthenticationClient;
import org.symphonyoss.symphony.clients.ConnectionsClient;
import org.symphonyoss.symphony.clients.ConnectionsFactory;
import org.symphonyoss.symphony.clients.DataFeedClient;
import org.symphonyoss.symphony.clients.DataFeedFactory;
import org.symphonyoss.symphony.clients.MessagesClient;
import org.symphonyoss.symphony.clients.MessagesFactory;
import org.symphonyoss.symphony.clients.PresenceClient;
import org.symphonyoss.symphony.clients.PresenceFactory;
import org.symphonyoss.symphony.clients.RoomMembershipClient;
import org.symphonyoss.symphony.clients.RoomMembershipFactory;
import org.symphonyoss.symphony.clients.ShareClient;
import org.symphonyoss.symphony.clients.ShareFactory;
import org.symphonyoss.symphony.clients.StreamsClient;
import org.symphonyoss.symphony.clients.StreamsFactory;
import org.symphonyoss.symphony.clients.SymphonyApis;
import org.symphonyoss.symphony.clients.SymphonyApisFactory;
import org.symphonyoss.symphony.clients.UsersClient;
import org.symphonyoss.symphony.clients.UsersFactory;
import org.symphonyoss.symphony.clients.jmx.ClientCheck;
import org.symphonyoss.symphony.clients.model.ApiVersion;
import org.symphonyoss.symphony.clients.model.SymUser;

public class SymphonyBasicClient
implements SymphonyClient {
    private final Logger logger = LoggerFactory.getLogger(SymphonyBasicClient.class);
    private SymAuth symAuth;
    private MessageService messageService;
    private ChatService chatService;
    private RoomService roomService;
    private PresenceService presenceService;
    private SymUser localUser;
    private String agentUrl;
    private String podUrl;
    private MessagesClient messagesClient;
    private DataFeedClient dataFeedClient;
    private UsersClient usersClient;
    private StreamsClient streamsClient;
    private PresenceClient presenceClient;
    private RoomMembershipClient roomMembershipClient;
    private AttachmentsClient attachmentsClient;
    private ConnectionsClient connectionsClient;
    private ShareClient shareClient;
    private SymphonyApis symphonyApis;
    private Client defaultHttpClient;
    private Client podHttpClient;
    private Client agentHttpClient;
    private SymphonyClientConfig config;
    private final long SYMAUTH_REFRESH_TIME = Long.parseLong(System.getProperty("symauth.refresh.time", "7200000"));
    private SymUserCache symUserCache;
    private ApiVersion apiVersion = ApiVersion.V4;
    private String name;
    private Timer timer;

    public SymphonyBasicClient() {
        this(ApiVersion.V4);
    }

    public SymphonyBasicClient(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public void init(SymphonyClientConfig config) throws InitException, AuthenticationException {
        this.config = config;
        try {
            this.init(CustomHttpClient.getDefaultHttpClient(config), config);
        }
        catch (Exception e) {
            throw new InitException("Failed to initialize network...", e);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init(Client podHttpClient, Client agentHttpClient, SymphonyClientConfig config) throws InitException, AuthenticationException {
        this.podHttpClient = podHttpClient;
        this.agentHttpClient = agentHttpClient;
        this.defaultHttpClient = podHttpClient;
        this.config = config;
        AuthenticationClient authClient = new AuthenticationClient(config.get(SymphonyClientConfigID.SESSIONAUTH_URL), config.get(SymphonyClientConfigID.KEYAUTH_URL), agentHttpClient);
        SymAuth symAuth = authClient.authenticate();
        this.init(symAuth, config);
    }

    @Override
    public void init(Client httpClient, SymphonyClientConfig config) throws InitException, AuthenticationException {
        this.defaultHttpClient = httpClient;
        this.init(this.defaultHttpClient, this.defaultHttpClient, config);
    }

    @Override
    @Deprecated
    public void init(SymAuth symAuth, String userEmail, String agentUrl, String podUrl) throws InitException {
        this.updateConfig(agentUrl, podUrl, userEmail);
        this.init(symAuth, this.config);
    }

    @Override
    @Deprecated
    public void init(Client httpClient, SymAuth symAuth, String userEmail, String agentUrl, String podUrl) throws InitException {
        this.defaultHttpClient = httpClient;
        this.agentHttpClient = httpClient;
        this.defaultHttpClient = httpClient;
        this.updateConfig(agentUrl, podUrl, userEmail);
        this.init(symAuth, this.config);
    }

    @Override
    @Deprecated
    public void init(SymAuth symAuth, String userEmail, String agentUrl, String podUrl, boolean disableServices) throws InitException {
        this.updateConfig(agentUrl, podUrl, userEmail);
        this.config.set(SymphonyClientConfigID.DISABLE_SERVICES, String.valueOf(disableServices));
        this.init(symAuth, this.config);
    }

    @Override
    public void init(SymAuth symAuth, SymphonyClientConfig config) throws InitException {
        this.config = config;
        this.symAuth = symAuth;
        this.updateConfig(config);
        try {
            if (this.defaultHttpClient == null) {
                this.defaultHttpClient = CustomHttpClient.getDefaultHttpClient(config);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not set default http client from config...", (Throwable)e);
        }
        if (this.podHttpClient == null) {
            this.podHttpClient = this.defaultHttpClient;
        }
        if (this.agentHttpClient == null) {
            this.agentHttpClient = this.defaultHttpClient;
        }
        String NOT_LOGGED_IN_MESSAGE = "Currently not logged into Agent, please check certificates and tokens.";
        if (symAuth == null || symAuth.getSessionToken() == null || symAuth.getKeyToken() == null) {
            throw new InitException("Symphony Authorization is not valid", new Throwable(NOT_LOGGED_IN_MESSAGE));
        }
        if (config.get(SymphonyClientConfigID.AGENT_URL) == null) {
            throw new InitException("Failed to provide agent URL", new Throwable("Failed to provide agent URL"));
        }
        if (config.get(SymphonyClientConfigID.POD_URL) == null) {
            throw new InitException("Failed to provide service URL", new Throwable("Failed to provide service URL"));
        }
        this.symAuth = symAuth;
        this.name = config.get(SymphonyClientConfigID.USER_EMAIL);
        this.dataFeedClient = DataFeedFactory.getClient(this);
        this.messagesClient = MessagesFactory.getClient(this);
        this.presenceClient = PresenceFactory.getClient(this);
        this.streamsClient = StreamsFactory.getClient(this);
        this.usersClient = UsersFactory.getClient(this);
        this.shareClient = ShareFactory.getClient(this);
        this.attachmentsClient = AttachmentsFactory.getClient(this);
        this.roomMembershipClient = RoomMembershipFactory.getClient(this);
        this.connectionsClient = ConnectionsFactory.getClient(this);
        this.symphonyApis = SymphonyApisFactory.getClient(this);
        try {
            if (!Boolean.parseBoolean(config.get(SymphonyClientConfigID.DISABLE_SERVICES, "False"))) {
                this.messageService = new MessageService(this);
                this.chatService = new ChatService(this);
                this.roomService = new RoomService(this);
                this.presenceService = new PresenceService(this);
            }
            this.localUser = this.usersClient.getUserBySession(symAuth);
        }
        catch (SymException e) {
            this.logger.error("Failed to initialize client..", (Throwable)e);
            throw new InitException("Could not initialize one of the Symphony API services. This is most likely due to not having the right agent or pod URLs. This can also be an issue with the client certificate or server.truststore. Here is what you have configured:\nSessionToken: " + symAuth.getSessionToken() + "\nKeyToken: " + symAuth.getKeyToken() + "\nEmail: " + config.get(SymphonyClientConfigID.USER_EMAIL) + "\nAgentUrl: " + config.get(SymphonyClientConfigID.AGENT_URL) + "\npodUrl: " + config.get(SymphonyClientConfigID.POD_URL));
        }
        this.symUserCache = new DefaultUserCache(this);
        AuthRefreshTask authRefreshTask = new AuthRefreshTask(this);
        this.timer = new Timer("AuthRefresh:" + this.getName(), true);
        this.timer.scheduleAtFixedRate((TimerTask)authRefreshTask, this.SYMAUTH_REFRESH_TIME, this.SYMAUTH_REFRESH_TIME);
        if (Boolean.parseBoolean(config.get(SymphonyClientConfigID.HEALTHCHECK_JMX_ENABLED, "True"))) {
            this.logger.info("Registering JMX Health Bean...");
            this.registerHealthMBean();
        }
    }

    @Override
    public SymAuth getSymAuth() {
        return this.symAuth;
    }

    @Override
    public void setSymAuth(SymAuth symAuth) {
        this.symAuth = symAuth;
    }

    @Override
    public String getAgentUrl() {
        return this.agentUrl;
    }

    public void setAgentUrl(String agentUrl) {
        this.agentUrl = agentUrl;
    }

    @Override
    public String getPodUrl() {
        return this.podUrl;
    }

    public void setPodUrl(String podUrl) {
        this.podUrl = podUrl;
    }

    @Override
    public DataFeedClient getDataFeedClient() {
        return this.dataFeedClient;
    }

    @Override
    public MessagesClient getMessagesClient() {
        return this.messagesClient;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Override
    public RoomService getRoomService() {
        return this.roomService;
    }

    @Override
    public SymUser getLocalUser() {
        return this.localUser;
    }

    public void setLocalUser(SymUser localUser) {
        this.localUser = localUser;
    }

    @Override
    public ChatService getChatService() {
        return this.chatService;
    }

    @Override
    public PresenceClient getPresenceClient() {
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        return this.usersClient;
    }

    @Override
    public RoomMembershipClient getRoomMembershipClient() {
        return this.roomMembershipClient;
    }

    @Override
    public AttachmentsClient getAttachmentsClient() {
        return this.attachmentsClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        return this.connectionsClient;
    }

    @Override
    public ShareClient getShareClient() {
        return this.shareClient;
    }

    @Override
    public Client getDefaultHttpClient() {
        return this.defaultHttpClient;
    }

    @Override
    public void setDefaultHttpClient(Client defaultHttpClient) {
        this.defaultHttpClient = defaultHttpClient;
    }

    @Override
    public void setCache(SymCache symCache) throws SymCacheException {
        if (symCache.getCacheType() == null) {
            throw new SymCacheException("Cache type not set...");
        }
        if (symCache.getCacheType() == CacheType.USER) {
            this.symUserCache = (SymUserCache)symCache;
        }
    }

    @Override
    public SymCache getCache(CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            return this.symUserCache;
        }
        return null;
    }

    @Override
    public void shutdown() {
        if (this.getMessageService() != null) {
            this.getMessageService().shutdown();
        }
        if (this.getPresenceService() != null) {
            this.getPresenceService().shutdown();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public Client getPodHttpClient() {
        return this.podHttpClient;
    }

    @Override
    public void setPodHttpClient(Client podHttpClient) {
        this.podHttpClient = podHttpClient;
    }

    @Override
    public Client getAgentHttpClient() {
        return this.agentHttpClient;
    }

    @Override
    public void setAgentHttpClient(Client agentHttpClient) {
        this.agentHttpClient = agentHttpClient;
    }

    @Override
    public SymphonyApis getSymphonyApis() {
        return this.symphonyApis;
    }

    @Override
    public SymphonyClientConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(SymphonyClientConfig config) {
        this.config = config;
    }

    @Override
    public PresenceService getPresenceService() {
        return this.presenceService;
    }

    private void updateConfig(String agentUrl, String podUrl, String userEmail) {
        if (this.config == null) {
            this.config = new SymphonyClientConfig(false);
        }
        this.config.set(SymphonyClientConfigID.AGENT_URL, agentUrl);
        this.config.set(SymphonyClientConfigID.POD_URL, podUrl);
        this.config.set(SymphonyClientConfigID.USER_EMAIL, userEmail);
    }

    private void updateConfig(SymphonyClientConfig config) {
        this.agentUrl = config.get(SymphonyClientConfigID.AGENT_URL);
        this.podUrl = config.get(SymphonyClientConfigID.POD_URL);
    }

    private void registerHealthMBean() {
        this.logger.info("Exposing SymAgentHealthCheck as JMX MBean...");
        ClientCheck clientCheck = new ClientCheck(this);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "org.symphonyoss.client:type=ClientCheckMBean";
        try {
            ObjectName mBean = new ObjectName(mBeanName);
            mbs.registerMBean(clientCheck, mBean);
            this.logger.info("Registered JMX Mbean: " + mbs.getMBeanInfo(mBean).getClassName());
        }
        catch (ReflectionException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
        catch (IntrospectionException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            this.logger.error("Cannot register JMX Mbean: " + mBeanName, (Throwable)e);
        }
    }
}

