/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.model;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.symphonyoss.client.services.ChatListener;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.clients.model.SymUser;

public class Chat {
    private Set<SymUser> remoteUsers;
    private SymUser localUser;
    private SymStream stream;
    private String streamId;
    private final Set<ChatListener> chatListeners = ConcurrentHashMap.newKeySet();
    private SymMessage lastMessage;

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
        if (this.stream == null) {
            this.stream = new SymStream();
        }
        this.stream.setStreamId(streamId);
    }

    public Set<SymUser> getRemoteUsers() {
        return this.remoteUsers;
    }

    public void setRemoteUsers(Set<SymUser> remoteUsers) {
        this.remoteUsers = remoteUsers;
    }

    public SymUser getLocalUser() {
        return this.localUser;
    }

    public void setLocalUser(SymUser localUser) {
        this.localUser = localUser;
    }

    public SymStream getStream() {
        return this.stream;
    }

    public void setStream(SymStream stream) {
        this.stream = stream;
        this.streamId = stream.getStreamId();
    }

    public void onChatMessage(SymMessage message) {
        this.lastMessage = message;
        for (ChatListener chatListener : this.chatListeners) {
            chatListener.onChatMessage(message);
        }
    }

    @Deprecated
    public boolean registerListener(ChatListener chatListener) {
        return this.addListener(chatListener);
    }

    public boolean addListener(ChatListener chatListener) {
        if (this.lastMessage != null) {
            chatListener.onChatMessage(this.lastMessage);
        }
        return this.chatListeners.add(chatListener);
    }

    public boolean removeListener(ChatListener chatListener) {
        return this.chatListeners.remove(chatListener);
    }

    public SymMessage getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(SymMessage lastMessage) {
        this.lastMessage = lastMessage;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chat other = (Chat)obj;
        return this.stream != null && this.stream.equals(other.stream);
    }

    public int hashCode() {
        return Objects.hash(this.stream, this.remoteUsers);
    }
}

