/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.model;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.symphonyoss.client.services.RoomEventListener;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymRoomDetail;
import org.symphonyoss.symphony.pod.model.MembershipList;
import org.symphonyoss.symphony.pod.model.Stream;

public class Room {
    private String id;
    private Stream stream;
    private String streamId;
    private MembershipList membershipList;
    private SymRoomDetail roomDetail;
    private final Set<RoomEventListener> roomEventListeners = ConcurrentHashMap.newKeySet();

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
        if (this.stream == null) {
            this.stream = new Stream();
            this.stream.setId(streamId);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MembershipList getMembershipList() {
        return this.membershipList;
    }

    public void setMembershipList(MembershipList membershipList) {
        this.membershipList = membershipList;
    }

    public SymRoomDetail getRoomDetail() {
        return this.roomDetail;
    }

    public void setRoomDetail(SymRoomDetail roomDetail) {
        this.roomDetail = roomDetail;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
        if (this.streamId == null) {
            this.streamId = stream.getId();
        }
    }

    public Set<RoomEventListener> getRoomEventListeners() {
        return this.roomEventListeners;
    }

    public void onRoomMessage(SymMessage message) {
        for (RoomEventListener roomEventListener : this.roomEventListeners) {
            roomEventListener.onRoomMessage(message);
        }
    }

    public void addEventListener(RoomEventListener roomEventListener) {
        this.roomEventListeners.add(roomEventListener);
    }

    public void removeEventListener(RoomEventListener roomEventListener) {
        this.roomEventListeners.remove(roomEventListener);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Room)) {
            return false;
        }
        Room room = (Room)o;
        return this.id.equals(room.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.stream);
    }
}

