/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.StreamsException;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.CacheType;
import org.symphonyoss.client.model.Chat;
import org.symphonyoss.client.services.ChatListener;
import org.symphonyoss.client.services.ChatServiceListener;
import org.symphonyoss.client.services.SymUserCache;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.clients.model.SymUser;

public class ChatService
implements ChatListener {
    private final ConcurrentHashMap<String, Chat> chatsByStream = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<Chat>> chatsByUser = new ConcurrentHashMap();
    private final Set<ChatServiceListener> chatServiceListeners = ConcurrentHashMap.newKeySet();
    private final SymphonyClient symClient;
    private final Logger logger = LoggerFactory.getLogger(ChatService.class);

    public ChatService(SymphonyClient symClient) {
        this.symClient = symClient;
        symClient.getMessageService().addChatListener(this);
    }

    public boolean addChat(Chat chat) {
        return this.addChat(chat, true);
    }

    private boolean addChat(Chat chat, boolean updateStream) {
        if (chat == null || chat.getRemoteUsers() == null) {
            return false;
        }
        if (!this.updateSymUsers(chat)) {
            this.logger.error("Failed to register chat conversation because some or all users can not be identified...please check!");
            return false;
        }
        if (updateStream) {
            try {
                SymStream stream = this.symClient.getStreamsClient().getStream(chat.getRemoteUsers());
                if (stream == null) {
                    this.logger.error("Failed to obtain stream ID for chat...");
                    return false;
                }
                chat.setStreamId(stream.getStreamId());
            }
            catch (StreamsException e) {
                this.logger.error("Failed to obtain stream ID for chat...", (Throwable)e);
                return false;
            }
        }
        if (this.chatsByStream.get(chat.getStreamId()) == null) {
            this.chatsByStream.put(chat.getStreamId(), chat);
            for (SymUser user : chat.getRemoteUsers()) {
                Set userChats = this.chatsByUser.computeIfAbsent(user.getId(), k -> new HashSet());
                if (userChats != null && userChats.add(chat)) {
                    this.logger.debug("Adding new chat for user {}:{}", (Object)user.getId(), (Object)user.getEmailAddress());
                    continue;
                }
                this.logger.debug("Chat with user {}:{} already exists..ignoring", (Object)user.getId(), (Object)user.getEmailAddress());
            }
            for (ChatServiceListener chatServiceListener : this.chatServiceListeners) {
                chatServiceListener.onNewChat(chat);
            }
            return true;
        }
        return false;
    }

    public boolean removeChat(Chat chat) {
        if (chat != null && chat.getStreamId() != null && this.chatsByStream.remove(chat.getStreamId()) != null) {
            for (SymUser user : chat.getRemoteUsers()) {
                Set<Chat> userChats = this.chatsByUser.get(user.getId());
                if (userChats.remove(chat)) {
                    this.logger.debug("Removed chat for user {}:{}", (Object)user.getId(), (Object)user.getEmailAddress());
                    continue;
                }
                this.logger.debug("Could not remove chats for user {}:{} on stream {}", new Object[]{user.getId(), user.getEmailAddress(), chat.getStreamId()});
            }
            for (ChatServiceListener chatServiceListener : this.chatServiceListeners) {
                chatServiceListener.onRemovedChat(chat);
            }
            return true;
        }
        return false;
    }

    private Chat createNewChatFromMessage(SymMessage message) {
        this.logger.info("Detected new chat on stream ID: {} FromUserID: {}", (Object)message.getStreamId(), (Object)message.getFromUserId());
        try {
            Chat chat = new Chat();
            chat.setLocalUser(this.symClient.getLocalUser());
            chat.setStreamId(message.getStreamId());
            chat.setLastMessage(message);
            Set<SymUser> remoteUsers = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUsersByStream(message.getStreamId());
            if (remoteUsers != null) {
                chat.setRemoteUsers(remoteUsers);
                return chat;
            }
        }
        catch (UsersClientException e) {
            this.logger.error("Could not create new chat from message {} {}", new Object[]{message.getStreamId(), message.getFromUserId(), e});
        }
        return null;
    }

    @Override
    public void onChatMessage(SymMessage symMessage) {
        if (symMessage == null) {
            return;
        }
        String streamId = symMessage.getStreamId();
        this.logger.debug("New message from stream {}", (Object)streamId);
        if (streamId != null) {
            Chat chat = this.chatsByStream.get(streamId);
            if (chat == null) {
                chat = this.createNewChatFromMessage(symMessage);
                if (chat != null) {
                    this.addChat(chat, false);
                } else {
                    this.logger.error("Failed to add new chat from message {} {}", (Object)symMessage.getStreamId(), (Object)symMessage.getFromUserId());
                }
            } else {
                chat.onChatMessage(symMessage);
            }
        }
    }

    @Deprecated
    public boolean registerListener(ChatServiceListener chatServiceListener) {
        return this.chatServiceListeners.add(chatServiceListener);
    }

    public boolean addListener(ChatServiceListener chatServiceListener) {
        return this.chatServiceListeners.add(chatServiceListener);
    }

    public boolean removeListener(ChatServiceListener chatServiceListener) {
        return this.chatServiceListeners.remove(chatServiceListener);
    }

    public Set<Chat> getChatsByEmail(String email) {
        try {
            SymUser user = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUserByEmail(email);
            if (user != null) {
                return this.chatsByUser.get(user.getId());
            }
        }
        catch (UsersClientException e) {
            this.logger.error("Could not locate user by email {}", (Object)email, (Object)e);
        }
        return null;
    }

    public Set<Chat> getChats(SymUser user) {
        if (user != null) {
            return this.chatsByUser.get(user.getId());
        }
        return null;
    }

    public Chat getChatByStream(String streamId) {
        return this.chatsByStream.get(streamId);
    }

    private boolean updateSymUsers(Chat chat) {
        HashSet<SymUser> verifiedSymUsers = new HashSet<SymUser>();
        for (SymUser symUser : chat.getRemoteUsers()) {
            try {
                SymUser updatedSymUser = new SymUser();
                if (symUser.getId() != null) {
                    updatedSymUser = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUserById(symUser.getId());
                } else if (symUser.getEmailAddress() != null) {
                    updatedSymUser = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUserByEmail(symUser.getEmailAddress());
                } else if (symUser.getUsername() != null) {
                    updatedSymUser = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUserByName(symUser.getUsername());
                } else {
                    this.logger.error("Failed to retrieve user detail for chat session..(nothing to identify the user)..");
                }
                if (updatedSymUser.getId() == null) continue;
                verifiedSymUsers.add(updatedSymUser);
            }
            catch (UsersClientException e) {
                this.logger.error("Failed to retrieve user detail for chat session..(nothing to identify the user)..", (Throwable)e);
            }
        }
        if (chat.getRemoteUsers().size() != verifiedSymUsers.size()) {
            return false;
        }
        chat.setRemoteUsers(verifiedSymUsers);
        return true;
    }
}

