/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.events.SymConnectionAccepted;
import org.symphonyoss.client.events.SymConnectionRequested;
import org.symphonyoss.client.exceptions.ConnectionsException;
import org.symphonyoss.client.services.ChatService;
import org.symphonyoss.client.services.ConnectionsEventListener;
import org.symphonyoss.client.services.ConnectionsListener;
import org.symphonyoss.client.services.ConnectionsWorker;
import org.symphonyoss.symphony.clients.model.SymUserConnection;

public class ConnectionsService
implements ConnectionsListener,
ConnectionsEventListener {
    private final SymphonyClient symClient;
    private boolean autoAccept;
    private final Set<ConnectionsListener> connectionsListeners = ConcurrentHashMap.newKeySet();
    private final Logger logger = LoggerFactory.getLogger(ChatService.class);
    private ConnectionsWorker connectionsWorker;

    public ConnectionsService(SymphonyClient symClient) {
        this.symClient = symClient;
        this.connectionsWorker = new ConnectionsWorker(symClient, this);
        symClient.getMessageService().addConnectionsEventListener(this);
        new Thread((Runnable)this.connectionsWorker, "ConnectionsWorker: " + symClient.getName()).start();
    }

    @Override
    public void onConnectionNotification(SymUserConnection userConnection) {
        for (ConnectionsListener connectionsListener : this.connectionsListeners) {
            connectionsListener.onConnectionNotification(userConnection);
        }
        try {
            if (this.autoAccept) {
                this.symClient.getConnectionsClient().acceptConnectionRequest(userConnection);
            }
        }
        catch (ConnectionsException e) {
            this.logger.error("Could not autoaccept connection request from {}", (Object)userConnection.getUserId(), (Object)e);
        }
    }

    @Deprecated
    public void registerListener(ConnectionsListener connectionsListener) {
        this.addListener(connectionsListener);
    }

    public void addListener(ConnectionsListener connectionsListener) {
        this.connectionsListeners.add(connectionsListener);
    }

    public void removeListener(ConnectionsListener connectionsListener) {
        this.connectionsListeners.remove(connectionsListener);
    }

    public boolean isAutoAccept() {
        return this.autoAccept;
    }

    public void setAutoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
    }

    public void shutdown() {
        this.connectionsWorker.shutdown();
        this.connectionsWorker = null;
    }

    @Override
    public void onSymConnectionRequested(SymConnectionRequested symConnectionRequested) {
        SymUserConnection symUserConnection = new SymUserConnection();
        symUserConnection.setUserId(symConnectionRequested.getToUser().getId());
        this.onConnectionNotification(symUserConnection);
    }

    @Override
    public void onSymConnectionAccepted(SymConnectionAccepted symConnectionAccepted) {
    }
}

