/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.ConnectionsException;
import org.symphonyoss.client.services.ConnectionsListener;
import org.symphonyoss.symphony.clients.model.SymUserConnection;

class ConnectionsWorker
implements Runnable {
    private final SymphonyClient symClient;
    private final ConnectionsListener connectionsListener;
    private final ConcurrentHashMap<Long, SymUserConnection> pendingConnections = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger(ConnectionsWorker.class);
    private boolean KILL = false;
    private final int CONNECTIONS_POLL_SLEEP = Integer.parseInt(System.getProperty("connections.poll.sleep", "30"));

    public ConnectionsWorker(SymphonyClient symClient, ConnectionsListener connectionsListener) {
        this.symClient = symClient;
        this.connectionsListener = connectionsListener;
    }

    @Override
    public void run() {
        this.logger.info("Starting connections service worker..");
        while (true) {
            try {
                TimeUnit.SECONDS.sleep(this.CONNECTIONS_POLL_SLEEP);
            }
            catch (InterruptedException ie) {
                this.logger.error("Interrupt failed on presence retrieval", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            try {
                List<SymUserConnection> symUserConnectionList;
                try {
                    symUserConnectionList = this.symClient.getConnectionsClient().getIncomingRequests();
                }
                catch (ProcessingException | ConnectionsException e) {
                    this.logger.error("Pending connections request retrieval failure", e);
                    continue;
                }
                if (symUserConnectionList != null) {
                    for (SymUserConnection symUserConnection : symUserConnectionList) {
                        SymUserConnection cUserConnection = this.pendingConnections.get(symUserConnection.getUserId());
                        if (cUserConnection == null) {
                            this.pendingConnections.put(symUserConnection.getUserId(), symUserConnection);
                            this.connectionsListener.onConnectionNotification(symUserConnection);
                            this.logger.debug("Received new pending connection request from {}...", (Object)symUserConnection.getUserId());
                            continue;
                        }
                        if (cUserConnection.getStatus() == symUserConnection.getStatus()) continue;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Connection status changed for {}: from: {}  to:{}", new Object[]{cUserConnection.getUserId(), cUserConnection.getStatus().toString(), symUserConnection.getStatus().toString()});
                        }
                        this.pendingConnections.remove(symUserConnection.getUserId());
                        this.connectionsListener.onConnectionNotification(symUserConnection);
                    }
                }
                if (!this.KILL) continue;
                this.logger.debug("Connections worker thread killed..");
                return;
            }
            catch (Exception bad) {
                this.logger.error("Serious failure in connections worker thread..please verify stacktrace.", (Throwable)bad);
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        this.KILL = true;
    }
}

