/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.events.SymEvent;
import org.symphonyoss.client.services.DataFeedListener;
import org.symphonyoss.symphony.clients.model.ApiVersion;
import org.symphonyoss.symphony.clients.model.SymDatafeed;

class DataFeedWorker
implements Runnable {
    private final DataFeedListener dataFeedListener;
    private final SymphonyClient symClient;
    private final Logger logger = LoggerFactory.getLogger(DataFeedWorker.class);
    private SymDatafeed datafeed;
    private boolean shutdown;

    public DataFeedWorker(SymphonyClient symClient, DataFeedListener dataFeedListener) {
        this.symClient = symClient;
        this.dataFeedListener = dataFeedListener;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            this.initDatafeed();
            this.readDatafeed();
        }
    }

    private void initDatafeed() {
        while (this.datafeed == null) {
            try {
                this.logger.info("Creating datafeed with pod...");
                this.datafeed = this.symClient.getDataFeedClient().createDatafeed(ApiVersion.V4);
                break;
            }
            catch (Exception e) {
                this.logger.error("Failed to create datafeed with pod, please check connection..", (Throwable)e);
                this.datafeed = null;
                try {
                    TimeUnit.SECONDS.sleep(Long.valueOf(System.getProperty("datafeed.recovery.wait.time", "5")));
                }
                catch (InterruptedException e1) {
                    this.logger.error("Interrupt.. ", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void readDatafeed() {
        try {
            List<SymEvent> symEvents = this.symClient.getDataFeedClient().getEventsFromDatafeed(this.datafeed);
            if (symEvents != null) {
                symEvents.forEach(this.dataFeedListener::onEvent);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create read datafeed from pod, please check connection..resetting.", (Throwable)e);
            this.datafeed = null;
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

