/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.events.SymEvent;
import org.symphonyoss.client.exceptions.DataFeedException;
import org.symphonyoss.client.exceptions.SystemException;
import org.symphonyoss.client.services.FirehoseListener;
import org.symphonyoss.client.services.FirehoseWorker;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.clients.AgentSystemClient;
import org.symphonyoss.symphony.clients.AgentSystemClientFactory;
import org.symphonyoss.symphony.clients.FirehoseClientFactory;
import org.symphonyoss.symphony.clients.model.RestApiVersion;
import org.symphonyoss.symphony.clients.model.SymAgentHealthCheck;

public class FirehoseService
implements FirehoseListener {
    private final SymphonyClient symClient;
    private ApiClient agentClient;
    private final Logger logger = LoggerFactory.getLogger(FirehoseService.class);
    private final Set<FirehoseListener> firehoseListeners = ConcurrentHashMap.newKeySet();
    private FirehoseWorker firehoseWorker;

    public FirehoseService(SymphonyClient symClient) {
        this.symClient = symClient;
    }

    public void init() throws DataFeedException {
        RestApiVersion restApiVersion = RestApiVersion.v1_49_0;
        AgentSystemClient agentSystemClient = AgentSystemClientFactory.getClient(this.symClient);
        try {
            SymAgentHealthCheck symAgentHealthCheck = agentSystemClient.getAgentHealthCheck();
            if (!restApiVersion.isCompatible(symAgentHealthCheck.getAgentVersion())) {
                throw new DataFeedException("Agent Server doesn't support Firehose.  It must be 1.49 or higher. Version detected=" + symAgentHealthCheck.getAgentVersion(), 0, null);
            }
        }
        catch (SystemException e) {
            throw new DataFeedException("Failed to obtain agent server version", 0, e.getCause());
        }
        this.firehoseWorker = new FirehoseWorker(FirehoseClientFactory.getClient(this.symClient), this);
        new Thread((Runnable)this.firehoseWorker, "FirehoseWorker: " + this.symClient.getName()).start();
    }

    @Override
    public void onEvent(SymEvent symEvent) {
        this.logger.debug("{} event type received...", (Object)symEvent.getType());
        for (FirehoseListener firehoseListener : this.firehoseListeners) {
            firehoseListener.onEvent(symEvent);
        }
    }

    public void addFirehoseListener(FirehoseListener firehoseListener) {
        this.firehoseListeners.add(firehoseListener);
    }

    public boolean removeFirehoseListener(FirehoseListener firehoseListener) {
        return this.firehoseListeners.remove(firehoseListener);
    }

    public void shutdown() {
        if (this.firehoseWorker != null) {
            this.firehoseWorker.shutdown();
            this.firehoseWorker = null;
        }
    }
}

