/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.events.SymEvent;
import org.symphonyoss.client.services.FirehoseListener;
import org.symphonyoss.symphony.clients.FirehoseClient;
import org.symphonyoss.symphony.clients.model.SymFirehose;
import org.symphonyoss.symphony.clients.model.SymFirehoseRequest;

class FirehoseWorker
implements Runnable {
    private final FirehoseListener firehoseListener;
    private final FirehoseClient firehoseClient;
    private final Logger logger = LoggerFactory.getLogger(FirehoseWorker.class);
    private SymFirehose symFirehose;
    private boolean shutdown;

    public FirehoseWorker(FirehoseClient firehoseClient, FirehoseListener firehoseListener) {
        this.firehoseClient = firehoseClient;
        this.firehoseListener = firehoseListener;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            this.initFirehose();
            this.readFirehose();
        }
    }

    private void initFirehose() {
        while (this.symFirehose == null) {
            try {
                this.logger.info("Creating symFirehose with pod...");
                this.symFirehose = this.firehoseClient.createFirehose();
                break;
            }
            catch (Exception e) {
                this.logger.error("Failed to create firehose with agent server, please check connection..", (Throwable)e);
                this.symFirehose = null;
                try {
                    TimeUnit.SECONDS.sleep(Long.valueOf(System.getProperty("datafeed.recovery.wait.time", "5")));
                }
                catch (InterruptedException e1) {
                    this.logger.error("Interrupt.. ", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void readFirehose() {
        try {
            SymFirehoseRequest symFirehoseRequest = new SymFirehoseRequest();
            symFirehoseRequest.setMaxMsgs(Integer.valueOf(System.getProperty("datafeed.max.messages", "100")));
            symFirehoseRequest.setTimeout(Integer.valueOf(System.getProperty("datafeed.wait.time", "5000")));
            List<SymEvent> symEvents = this.firehoseClient.getEventsFromFirehose(this.symFirehose, symFirehoseRequest);
            if (symEvents != null) {
                symEvents.forEach(this.firehoseListener::onEvent);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create read firehose from pod, please check connection..resetting.", (Throwable)e);
            this.symFirehose = null;
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

