/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.events.SymConnectionAccepted;
import org.symphonyoss.client.events.SymConnectionRequested;
import org.symphonyoss.client.events.SymEvent;
import org.symphonyoss.client.events.SymEventTypes;
import org.symphonyoss.client.events.SymIMCreated;
import org.symphonyoss.client.events.SymRoomCreated;
import org.symphonyoss.client.events.SymRoomDeactivated;
import org.symphonyoss.client.events.SymRoomMemberDemotedFromOwner;
import org.symphonyoss.client.events.SymRoomMemberPromotedToOwner;
import org.symphonyoss.client.events.SymRoomReactivated;
import org.symphonyoss.client.events.SymRoomUpdated;
import org.symphonyoss.client.events.SymUserJoinedRoom;
import org.symphonyoss.client.events.SymUserLeftRoom;
import org.symphonyoss.client.exceptions.MessagesException;
import org.symphonyoss.client.exceptions.StreamsException;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.CacheType;
import org.symphonyoss.client.model.Chat;
import org.symphonyoss.client.model.Room;
import org.symphonyoss.client.services.ChatListener;
import org.symphonyoss.client.services.ConnectionsEventListener;
import org.symphonyoss.client.services.DataFeedListener;
import org.symphonyoss.client.services.DataFeedWorker;
import org.symphonyoss.client.services.MessageListener;
import org.symphonyoss.client.services.RoomServiceEventListener;
import org.symphonyoss.client.services.SymUserCache;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.clients.model.SymStreamTypes;
import org.symphonyoss.symphony.clients.model.SymUser;

public class MessageService
implements DataFeedListener {
    private final SymphonyClient symClient;
    private ApiClient agentClient;
    private final Logger logger = LoggerFactory.getLogger(MessageService.class);
    private final Set<MessageListener> messageListeners = ConcurrentHashMap.newKeySet();
    private final Set<ChatListener> chatListeners = ConcurrentHashMap.newKeySet();
    private final Set<RoomServiceEventListener> roomServiceEventListeners = ConcurrentHashMap.newKeySet();
    private final Set<ConnectionsEventListener> connectionsEventListeners = ConcurrentHashMap.newKeySet();
    private final Set<String> roomStreamCache = ConcurrentHashMap.newKeySet();
    private final Set<String> chatStreamCache = ConcurrentHashMap.newKeySet();
    DataFeedWorker dataFeedWorker;

    public MessageService(SymphonyClient symClient) {
        this.symClient = symClient;
        this.dataFeedWorker = new DataFeedWorker(symClient, this);
        new Thread((Runnable)this.dataFeedWorker, "DataFeedWorker: " + symClient.getName()).start();
    }

    public SymMessage sendMessage(Room room, SymMessage symMessage) throws MessagesException {
        return this.symClient.getMessagesClient().sendMessage(room.getStream(), symMessage);
    }

    public SymMessage sendMessage(Chat chat, SymMessage symMessage) throws MessagesException {
        return this.symClient.getMessagesClient().sendMessage(chat.getStream(), symMessage);
    }

    public SymMessage sendMessage(String email, SymMessage symMessage) throws MessagesException {
        try {
            SymUser remoteUser = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUserByEmail(email);
            return this.symClient.getMessagesClient().sendMessage(this.symClient.getStreamsClient().getStream(remoteUser), symMessage);
        }
        catch (UsersClientException e) {
            throw new MessagesException("Failed to find user from email address: " + email, e);
        }
        catch (StreamsException e) {
            throw new MessagesException("Failed to send message. Unable to identify stream from email: " + email, e);
        }
    }

    public SymMessage sendMessage(SymUser symUser, SymMessage symMessage) throws MessagesException {
        if (symUser.getId() == null) {
            throw new MessagesException("Failed to send message. SymUser ID not provided");
        }
        try {
            return this.symClient.getMessagesClient().sendMessage(this.symClient.getStreamsClient().getStream(symUser), symMessage);
        }
        catch (StreamsException e) {
            throw new MessagesException("Failed to send message. Unable to identify stream from userId: " + symUser.getId(), e);
        }
    }

    public SymMessage sendMessage(SymStream symStream, SymMessage symMessage) throws MessagesException {
        if (symStream.getStreamId() == null) {
            throw new MessagesException("Failed to send message. StreamID not provided");
        }
        try {
            return this.symClient.getMessagesClient().sendMessage(symStream, symMessage);
        }
        catch (MessagesException e) {
            throw new MessagesException("Failed to send message to streamId" + symStream.getStreamId(), e);
        }
    }

    private List<SymMessage> getMessagesFromStream(SymStream stream, Long since, Integer offset, Integer maxMessages) throws MessagesException {
        return this.symClient.getMessagesClient().getMessagesFromStream(stream, since, offset, maxMessages);
    }

    public List<SymMessage> getMessagesFromUserId(long userId, Long since, Integer offset, Integer maxMessages) throws MessagesException {
        SymUser user = new SymUser();
        user.setId(userId);
        try {
            return this.getMessagesFromStream(this.symClient.getStreamsClient().getStream(user), since, offset, maxMessages);
        }
        catch (StreamsException e) {
            throw new MessagesException("Failed to retrieve messages. Unable to identity stream for userId: " + userId, e);
        }
    }

    @Override
    public void onEvent(SymEvent symEvent) {
        this.logger.debug("{} event type received...", (Object)symEvent.getType());
        if (symEvent.getType() == null) {
            return;
        }
        SymEventTypes.Type type = SymEventTypes.Type.fromValue(symEvent.getType());
        if (type == null) {
            return;
        }
        switch (type) {
            case MESSAGESENT: {
                SymMessage symMessage = symEvent.getPayload().getMessageSent();
                if (symMessage == null || this.symClient.getLocalUser().getId().equals(symMessage.getFromUserId())) break;
                if (symMessage.getStream().getStreamType().equals((Object)SymStreamTypes.Type.ROOM)) {
                    for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                        roomServiceEventListener.onMessage(symMessage);
                    }
                } else if (symMessage.getStream().getStreamType().equals((Object)SymStreamTypes.Type.POST)) {
                    this.logger.warn("POST services not implemented..");
                } else {
                    for (ChatListener chatListener : this.chatListeners) {
                        chatListener.onChatMessage(symMessage);
                    }
                }
                for (MessageListener messageListener : this.messageListeners) {
                    messageListener.onMessage(symMessage);
                }
                this.logger.debug("TS: {}\nFrom ID: {}\nSymMessage: {}\nType: {}", new Object[]{symMessage.getTimestamp(), symMessage.getFromUserId(), symMessage.getMessage(), symMessage.getStream().getStreamType().toString()});
                break;
            }
            case INSTANTMESSAGECREATED: {
                SymIMCreated symIMCreated = symEvent.getPayload().getInstantMessageCreated();
                if (symIMCreated == null) break;
                this.logger.debug("Instant message create event not implemented");
                break;
            }
            case ROOMCREATED: {
                SymRoomCreated symRoomCreated = symEvent.getPayload().getRoomCreated();
                if (symRoomCreated == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymRoomCreated(symRoomCreated);
                }
                break;
            }
            case ROOMUPDATED: {
                SymRoomUpdated symRoomUpdated = symEvent.getPayload().getRoomUpdated();
                if (symRoomUpdated == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymRoomUpdated(symRoomUpdated);
                }
                break;
            }
            case ROOMDEACTIVATED: {
                SymRoomDeactivated symRoomDeactivated = symEvent.getPayload().getRoomDeactivated();
                if (symRoomDeactivated == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymRoomDeactivated(symRoomDeactivated);
                }
                break;
            }
            case ROOMREACTIVATED: {
                SymRoomReactivated symRoomReactivated = symEvent.getPayload().getRoomReactivated();
                if (symRoomReactivated == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymRoomReactivated(symRoomReactivated);
                }
                break;
            }
            case USERJOINEDROOM: {
                SymUserJoinedRoom symUserJoinedRoom = symEvent.getPayload().getUserJoinedRoom();
                if (symUserJoinedRoom == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymUserJoinedRoom(symUserJoinedRoom);
                }
                break;
            }
            case USERLEFTROOM: {
                SymUserLeftRoom symUserLeftRoom = symEvent.getPayload().getUserLeftRoom();
                if (symUserLeftRoom == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymUserLeftRoom(symUserLeftRoom);
                }
                break;
            }
            case ROOMMEMBERPROMOTEDTOOWNER: {
                SymRoomMemberPromotedToOwner symRoomMemberPromotedToOwner = symEvent.getPayload().getRoomMemberPromotedToOwner();
                if (symRoomMemberPromotedToOwner == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymRoomMemberPromotedToOwner(symRoomMemberPromotedToOwner);
                }
                break;
            }
            case ROOMMEMBERDEMOTEDFROMOWNER: {
                SymRoomMemberDemotedFromOwner symRoomMemberDemotedFromOwner = symEvent.getPayload().getRoomMemberDemotedFromOwner();
                if (symRoomMemberDemotedFromOwner == null) break;
                for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                    roomServiceEventListener.onSymRoomMemberDemotedFromOwner(symRoomMemberDemotedFromOwner);
                }
                break;
            }
            case CONNECTIONACCEPTED: {
                SymConnectionAccepted symConnectionAccepted = symEvent.getPayload().getConnectionAccepted();
                if (symConnectionAccepted == null) break;
                for (ConnectionsEventListener connectionsEventListener : this.connectionsEventListeners) {
                    connectionsEventListener.onSymConnectionAccepted(symConnectionAccepted);
                }
                break;
            }
            case CONNECTIONREQUESTED: {
                SymConnectionRequested symConnectionRequested = symEvent.getPayload().getConnectionRequested();
                if (symConnectionRequested == null) break;
                for (ConnectionsEventListener connectionsEventListener : this.connectionsEventListeners) {
                    connectionsEventListener.onSymConnectionRequested(symConnectionRequested);
                }
                break;
            }
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        this.messageListeners.add(messageListener);
    }

    public boolean removeMessageListener(MessageListener messageListener) {
        return this.messageListeners.remove(messageListener);
    }

    public void addRoomServiceEventListener(RoomServiceEventListener roomServiceEventListener) {
        this.roomServiceEventListeners.add(roomServiceEventListener);
    }

    public boolean removeRoomServiceEventListener(RoomServiceEventListener roomServiceEventListener) {
        return this.roomServiceEventListeners.remove(roomServiceEventListener);
    }

    public void addConnectionsEventListener(ConnectionsEventListener connectionsEventListener) {
        this.connectionsEventListeners.add(connectionsEventListener);
    }

    public boolean removeConnectionsEventListener(ConnectionsEventListener connectionsEventListener) {
        return this.connectionsEventListeners.remove(connectionsEventListener);
    }

    public void addChatListener(ChatListener chatListener) {
        this.chatListeners.add(chatListener);
    }

    public boolean removeChatListener(ChatListener chatListener) {
        return this.chatListeners.remove(chatListener);
    }

    public void shutdown() {
        if (this.dataFeedWorker != null) {
            this.dataFeedWorker.shutdown();
            this.dataFeedWorker = null;
        }
    }
}

