/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.PresenceException;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.CacheType;
import org.symphonyoss.client.services.PresenceFeedListener;
import org.symphonyoss.client.services.PresenceListener;
import org.symphonyoss.client.services.PresenceWorker;
import org.symphonyoss.client.services.SymUserCache;
import org.symphonyoss.symphony.clients.model.SymPresence;
import org.symphonyoss.symphony.clients.model.SymUser;

public class PresenceService
implements PresenceFeedListener {
    private final SymphonyClient symClient;
    private PresenceWorker presenceWorker;
    private final Set<PresenceListener> presenceListeners = ConcurrentHashMap.newKeySet();
    private final Logger logger = LoggerFactory.getLogger(PresenceService.class);

    public PresenceService(SymphonyClient symClient) {
        this.symClient = symClient;
    }

    public SymPresence getUserPresence(SymUser symUser, Boolean local) throws PresenceException {
        return this.symClient.getPresenceClient().getUserPresence(symUser, local);
    }

    public SymPresence getUserPresence(String email) throws PresenceException {
        SymUser symUser;
        if (email == null) {
            throw new NullPointerException("Email was not provided..");
        }
        try {
            symUser = ((SymUserCache)this.symClient.getCache(CacheType.USER)).getUserByEmail(email);
        }
        catch (UsersClientException e) {
            this.logger.error("Failed to obtain userID from email", (Throwable)e);
            throw new PresenceException("Failed to obtain user from email: " + email, e);
        }
        return symUser != null ? this.symClient.getPresenceClient().getUserPresence(symUser, (Boolean)false) : null;
    }

    public void addPresenceListener(PresenceListener presenceListener) {
        if (this.presenceWorker == null) {
            this.logger.debug("Starting presence worker thread..");
            this.presenceWorker = new PresenceWorker(this.symClient, this);
            new Thread((Runnable)this.presenceWorker, "PresenceWorker: " + this.symClient.getName()).start();
        }
        this.presenceListeners.add(presenceListener);
    }

    public void removePresenceListener(PresenceListener presenceListener) {
        this.presenceListeners.remove(presenceListener);
        if (this.presenceListeners.isEmpty()) {
            this.presenceWorker.shutdown();
            this.presenceWorker = null;
            this.logger.debug("Killing presence worker thread..");
        }
    }

    @Override
    public void onEvent(SymPresence symPresence) {
        for (PresenceListener listener : this.presenceListeners) {
            listener.onEvent(symPresence);
        }
    }

    public void shutdown() {
        if (this.presenceWorker != null) {
            this.presenceWorker.shutdown();
            this.presenceWorker = null;
        }
    }
}

