/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.PresenceException;
import org.symphonyoss.client.services.PresenceFeedListener;
import org.symphonyoss.symphony.clients.model.SymPresence;
import org.symphonyoss.symphony.clients.model.SymPresenceFeed;

class PresenceWorker
implements Runnable {
    private final PresenceFeedListener presenceFeedListener;
    private final SymphonyClient symClient;
    private final Logger logger = LoggerFactory.getLogger(PresenceWorker.class);
    private SymPresenceFeed symPresenceFeed;
    private boolean shutdown;

    public PresenceWorker(SymphonyClient symClient, PresenceFeedListener presenceFeedListener) {
        this.symClient = symClient;
        this.presenceFeedListener = presenceFeedListener;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            this.initDatafeed();
            this.readPresenceFeed();
        }
    }

    private void initDatafeed() {
        while (this.symPresenceFeed == null) {
            try {
                this.logger.info("Creating datafeed with pod...");
                this.symPresenceFeed = this.symClient.getPresenceClient().createPresenceFeed();
                break;
            }
            catch (Exception e) {
                this.logger.error("Failed to create presence feed with pod, please check connection..", (Throwable)e);
                this.symPresenceFeed = null;
                try {
                    TimeUnit.SECONDS.sleep(Long.valueOf(System.getProperty("presencefeed.recovery.wait.time", "5")));
                }
                catch (InterruptedException e1) {
                    this.logger.error("Interrupt.. ", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void readPresenceFeed() {
        try {
            List<SymPresence> symPresences = this.symClient.getPresenceClient().getPresenceFeedUpdates(this.symPresenceFeed);
            if (symPresences != null) {
                symPresences.forEach(this.presenceFeedListener::onEvent);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create read presence feed from pod, please check connection..resetting.", (Throwable)e);
            try {
                this.symClient.getPresenceClient().removePresenceFeed(this.symPresenceFeed);
            }
            catch (PresenceException e1) {
                this.logger.error("Failed to remove presence feed handler: {}", (Object)this.symPresenceFeed.getId());
            }
            this.symPresenceFeed = null;
            try {
                TimeUnit.SECONDS.sleep(Long.valueOf(System.getProperty("presencefeed.recovery.wait.time", "5")));
            }
            catch (InterruptedException e1) {
                this.logger.error("Interrupt.. ", (Throwable)e1);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

