/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.services;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.events.SymRoomCreated;
import org.symphonyoss.client.events.SymRoomDeactivated;
import org.symphonyoss.client.events.SymRoomMemberDemotedFromOwner;
import org.symphonyoss.client.events.SymRoomMemberPromotedToOwner;
import org.symphonyoss.client.events.SymRoomReactivated;
import org.symphonyoss.client.events.SymRoomUpdated;
import org.symphonyoss.client.events.SymUserJoinedRoom;
import org.symphonyoss.client.events.SymUserLeftRoom;
import org.symphonyoss.client.exceptions.RoomException;
import org.symphonyoss.client.exceptions.StreamsException;
import org.symphonyoss.client.exceptions.SymException;
import org.symphonyoss.client.model.Room;
import org.symphonyoss.client.services.MessageService;
import org.symphonyoss.client.services.RoomEventListener;
import org.symphonyoss.client.services.RoomServiceEventListener;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymRoomAttributes;
import org.symphonyoss.symphony.clients.model.SymRoomDetail;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.pod.model.Stream;

public class RoomService
implements RoomServiceEventListener {
    private final ConcurrentHashMap<String, Room> roomsByStream = new ConcurrentHashMap();
    private final SymphonyClient symClient;
    private final Logger logger = LoggerFactory.getLogger(RoomService.class);
    private final Set<RoomServiceEventListener> roomServiceEventListeners = ConcurrentHashMap.newKeySet();

    public RoomService(SymphonyClient symClient) {
        this.symClient = symClient;
        MessageService messageService = symClient.getMessageService();
        if (messageService != null) {
            messageService.addRoomServiceEventListener(this);
        }
    }

    public Room createRoom(SymRoomAttributes symRoomAttributes) throws RoomException {
        if (symRoomAttributes == null) {
            throw new NullPointerException("Room attributes were not provided..");
        }
        try {
            SymRoomDetail symRoomDetail = this.symClient.getStreamsClient().createChatRoom(symRoomAttributes);
            Room room = new Room();
            room.setId(symRoomDetail.getRoomSystemInfo().getId());
            room.setRoomDetail(symRoomDetail);
            room.setStreamId(room.getId());
            room.setMembershipList(this.symClient.getRoomMembershipClient().getRoomMembership(room.getId()));
            return room;
        }
        catch (StreamsException e) {
            this.logger.error("Failed to obtain stream for room...", (Throwable)e);
            throw new RoomException("Could not create/join chat room: " + symRoomAttributes.getName(), e);
        }
        catch (SymException e1) {
            this.logger.error("Failed to retrieve room membership...", (Throwable)e1);
            throw new RoomException("Could not retrieve room membership for room: " + symRoomAttributes.getName());
        }
    }

    public Room getRoom(String streamId) {
        return this.roomsByStream.get(streamId);
    }

    public Room getRoom(SymStream symStream) {
        return this.roomsByStream.get(symStream.getStreamId());
    }

    public void joinRoom(Room room) throws RoomException {
        if (room.getStream() == null || room.getStreamId() == null || room.getId() == null) {
            throw new RoomException("Room is not fully defined.  Check ID and stream ID");
        }
        try {
            room.setRoomDetail(this.symClient.getStreamsClient().getRoomDetail(room.getStreamId()));
            this.roomsByStream.put(room.getStreamId(), room);
        }
        catch (StreamsException e) {
            this.logger.error("Failed to obtain room detail...", (Throwable)e);
            throw new RoomException("Failed to obtain room detail for requested room: " + room.getStreamId(), e);
        }
    }

    @Override
    public void onMessage(SymMessage symMessage) {
        try {
            if (this.roomsByStream.get(symMessage.getStreamId()) == null) {
                this.addRoom(symMessage.getStreamId());
            }
            for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
                roomServiceEventListener.onMessage(symMessage);
            }
            Room room = this.roomsByStream.get(symMessage.getStreamId());
            if (room != null) {
                room.onRoomMessage(symMessage);
            }
        }
        catch (RoomException e) {
            this.logger.error("Unable to add new room from message: ", (Throwable)e);
        }
    }

    @Override
    public void onSymRoomDeactivated(SymRoomDeactivated symRoomDeactivated) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymRoomDeactivated(symRoomDeactivated);
            }
        }
    }

    @Override
    public void onSymRoomMemberDemotedFromOwner(SymRoomMemberDemotedFromOwner symRoomMemberDemotedFromOwner) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymRoomMemberDemotedFromOwner(symRoomMemberDemotedFromOwner);
            }
        }
    }

    @Override
    public void onSymRoomMemberPromotedToOwner(SymRoomMemberPromotedToOwner symRoomMemberPromotedToOwner) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymRoomMemberPromotedToOwner(symRoomMemberPromotedToOwner);
            }
        }
    }

    @Override
    public void onSymRoomReactivated(SymRoomReactivated symRoomReactivated) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymRoomReactivated(symRoomReactivated);
            }
        }
    }

    @Override
    public void onSymRoomUpdated(SymRoomUpdated symRoomUpdated) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymRoomUpdated(symRoomUpdated);
            }
        }
    }

    @Override
    public void onSymUserJoinedRoom(SymUserJoinedRoom symUserJoinedRoom) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymUserJoinedRoom(symUserJoinedRoom);
            }
        }
    }

    @Override
    public void onSymUserLeftRoom(SymUserLeftRoom symUserLeftRoom) {
        for (Map.Entry<String, Room> entry : this.roomsByStream.entrySet()) {
            for (RoomEventListener roomEventListener : entry.getValue().getRoomEventListeners()) {
                roomEventListener.onSymUserLeftRoom(symUserLeftRoom);
            }
        }
    }

    @Override
    public void onSymRoomCreated(SymRoomCreated symRoomCreated) {
        for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
            roomServiceEventListener.onSymRoomCreated(symRoomCreated);
        }
    }

    private void addRoom(String streamId) throws RoomException {
        Room room = new Room();
        Stream stream = new Stream();
        stream.setId(streamId);
        room.setStream(stream);
        room.setId(stream.getId());
        this.joinRoom(room);
        this.onNewRoom(room);
    }

    @Override
    public void onNewRoom(Room room) {
        for (RoomServiceEventListener roomServiceEventListener : this.roomServiceEventListeners) {
            roomServiceEventListener.onNewRoom(room);
        }
    }

    public void addRoomServiceEventListener(RoomServiceEventListener roomServiceEventListener) {
        this.roomServiceEventListeners.add(roomServiceEventListener);
    }

    public void removeRoomServiceEventListener(RoomServiceEventListener roomServiceEventListener) {
        this.roomServiceEventListeners.remove(roomServiceEventListener);
    }
}

