/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.client.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClient;
import org.symphonyoss.client.exceptions.SymException;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.AttribTypes;
import org.symphonyoss.client.model.NodeTypes;
import org.symphonyoss.symphony.clients.model.SymUser;
import org.xml.sax.helpers.DefaultHandler;

public class MlMessageParser
extends DefaultHandler {
    private String messageMl;
    private Element elementMessageML;
    private Document doc;
    private Document originalDoc;
    private StringBuilder textDoc = new StringBuilder();
    private String[] textChunks;
    private SymphonyClient symClient;
    private final Logger logger = LoggerFactory.getLogger(MlMessageParser.class);

    public MlMessageParser(SymphonyClient symClient) {
        this.symClient = symClient;
    }

    public MlMessageParser() {
    }

    public void parseMessage(String message) throws SymException {
        Document doc = Jsoup.parse((String)message);
        this.originalDoc = doc.clone();
        Element elementErrors = doc.body().getElementsByTag("errors").first();
        if (elementErrors != null && elementErrors.outerHtml() != null) {
            this.logger.debug("Errors found in message: {}", (Object)elementErrors.outerHtml());
        }
        doc.select("errors").remove();
        this.elementMessageML = doc.select("messageML").first();
        if (this.elementMessageML == null) {
            this.elementMessageML = doc.select("div").first();
        }
        if (this.elementMessageML != null) {
            if (this.elementMessageML.outerHtml() != null) {
                this.logger.debug("Doc parsed: {}", (Object)this.elementMessageML.outerHtml());
            }
        } else {
            this.logger.error("Could not parse document for message {}", (Object)message);
            throw new SymException("Malformed message");
        }
        this.textDoc = new StringBuilder();
        this.stripTags(this.textDoc, this.elementMessageML.childNodes());
        this.textChunks = this.textDoc.toString().split("\\s+");
    }

    public String[] getTextChunks() {
        return this.textChunks;
    }

    public void setTextChunks(String[] textChunks) {
        this.textChunks = textChunks;
    }

    private void stripTags(StringBuilder builder, List<Node> nodesList) {
        for (Node node : nodesList) {
            String nodeName = node.nodeName();
            if (nodeName.equalsIgnoreCase("#text")) {
                builder.append(node.toString().trim()).append(" ");
                continue;
            }
            if (nodeName.equalsIgnoreCase(NodeTypes.ANCHOR.toString())) {
                if (!node.attributes().hasKey(AttribTypes.HREF.toString())) continue;
                builder.append(node.attr(AttribTypes.HREF.toString()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(NodeTypes.HASHTAG.toString())) {
                if (!node.attributes().hasKey(AttribTypes.TAG.toString())) continue;
                builder.append("#").append(node.attr(AttribTypes.TAG.toString())).append(" ");
                continue;
            }
            if (nodeName.equalsIgnoreCase(NodeTypes.MENTION.toString())) {
                SymUser user = new SymUser();
                user.setEmailAddress("UID:" + node.attr(AttribTypes.UID.toString()));
                user.setId(Long.valueOf(node.attr(AttribTypes.UID.toString())));
                if (node.attributes().hasKey(AttribTypes.UID.toString())) {
                    if (this.symClient != null) {
                        try {
                            user = this.symClient.getUsersClient().getUserFromId(Long.valueOf(node.attr(AttribTypes.UID.toString())));
                        }
                        catch (UsersClientException e) {
                            this.logger.error("Could not identify user from userID", (Throwable)e);
                        }
                    }
                } else if (node.attributes().hasKey(AttribTypes.EMAIL.toString())) {
                    user.setEmailAddress(node.attr(AttribTypes.EMAIL.toString()));
                }
                builder.append(user.getEmailAddress());
                continue;
            }
            if (nodeName.equalsIgnoreCase(NodeTypes.CASHTAG.toString())) {
                if (!node.attributes().hasKey(AttribTypes.TAG.toString())) continue;
                builder.append("$").append(node.attr(AttribTypes.TAG.toString())).append(" ");
                continue;
            }
            this.stripTags(builder, node.childNodes());
        }
    }

    public String getText() {
        return this.textDoc.toString();
    }

    public String getOuterHtml() {
        return this.originalDoc.outerHtml();
    }

    public String getHtmlStartingFromText(String text) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getHtmlStartingFromText(text, stringBuilder, this.elementMessageML.childNodes(), false);
        return stringBuilder.toString();
    }

    public String getHtmlStartingFromNode(String nodeType, String attrib, String attribValue) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getHtmlStartingFromNode(nodeType, attrib, attribValue, stringBuilder, this.elementMessageML.childNodes(), false);
        return stringBuilder.toString();
    }

    public void getHtmlStartingFromText(String text, StringBuilder builder, List<Node> nodesList, boolean append) {
        for (Node node : nodesList) {
            String nodeName = node.nodeName();
            if (append) {
                builder.append(node.outerHtml());
                continue;
            }
            if (nodeName.equalsIgnoreCase("#text") && node.toString().trim().equalsIgnoreCase(text)) {
                append = true;
            }
            this.getHtmlStartingFromText(text, builder, node.childNodes(), append);
        }
    }

    private void getHtmlStartingFromNode(String nodeType, String attrib, String attribValue, StringBuilder builder, List<Node> nodesList, boolean append) {
        for (Node node : nodesList) {
            String nodeName = node.nodeName();
            if (append) {
                if (node.nodeName().equalsIgnoreCase("#text") && node.outerHtml().charAt(0) != ' ') {
                    builder.append(" ");
                }
                builder.append(node.outerHtml());
                if (node.nodeName().equalsIgnoreCase("#text")) continue;
                builder.append(" ");
                continue;
            }
            if (nodeName.equalsIgnoreCase(nodeType) && node.attributes().hasKey(attrib) && node.attr(attrib).equalsIgnoreCase(attribValue)) {
                append = true;
            }
            this.getHtmlStartingFromNode(nodeType, attrib, attribValue, builder, node.childNodes(), append);
        }
    }

    public void updateMentionUidToEmail(SymphonyClient symClient) {
        this.updateMentionUidToEmail(symClient, this.elementMessageML.childNodes());
    }

    private void updateMentionUidToEmail(SymphonyClient symClient, List<Node> nodesList) {
        for (Node node : nodesList) {
            String nodeName = node.nodeName();
            if (nodeName.equalsIgnoreCase(NodeTypes.MENTION.toString()) && node.attributes().hasKey(AttribTypes.UID.toString())) {
                String uid = node.attr(AttribTypes.UID.toString());
                SymUser user = null;
                try {
                    user = symClient.getUsersClient().getUserFromId(Long.parseLong(uid));
                    this.logger.info("Translated mention uid {} to email {}", (Object)uid, (Object)user.getEmailAddress());
                }
                catch (UsersClientException e) {
                    this.logger.error("Could not identify user email from id", (Throwable)e);
                }
                if (user != null && user.getEmailAddress() != null) {
                    uid = user.getEmailAddress();
                }
                Attribute emailAttribute = new Attribute(AttribTypes.EMAIL.toString(), uid);
                node.attributes().put(emailAttribute);
                node.removeAttr(AttribTypes.UID.toString());
            }
            this.updateMentionUidToEmail(symClient, node.childNodes());
        }
    }

    public Elements getAllElements() {
        return this.elementMessageML.getAllElements();
    }

    public List<Node> getChildNodes() {
        return this.elementMessageML.childNodes();
    }

    public static String escapeAllXml(String xml) {
        Pattern xmlCleanerPattern = Pattern.compile("(<[^/<>]*>)([^<>]*)(</[^<>]*>)");
        StringBuilder xmlStringBuilder = new StringBuilder();
        Matcher matcher = xmlCleanerPattern.matcher(xml);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                xmlStringBuilder.append(xml.substring(lastEnd, matcher.start()));
            }
            lastEnd = matcher.end();
            String cleanText = StringEscapeUtils.escapeXml((String)matcher.group(2));
            xmlStringBuilder.append(matcher.group(1)).append(cleanText).append(matcher.group(3));
        }
        xmlStringBuilder.append(xml.substring(lastEnd));
        return xmlStringBuilder.toString();
    }
}

