/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients;

import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.AuthenticationException;
import org.symphonyoss.client.impl.CustomHttpClient;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.authenticator.api.AuthenticationApi;
import org.symphonyoss.symphony.authenticator.invoker.ApiClient;
import org.symphonyoss.symphony.authenticator.invoker.ApiException;
import org.symphonyoss.symphony.authenticator.invoker.Configuration;
import org.symphonyoss.symphony.authenticator.model.AuthenticateRequest;
import org.symphonyoss.symphony.authenticator.model.Token;
import org.symphonyoss.symphony.clients.model.SymExtensionAppAuth;
import org.symphonyoss.symphony.clients.model.SymUser;

public class AuthenticationClient {
    private SymAuth symAuth;
    private final String sessionUrl;
    private final String keyUrl;
    private boolean loginStatus = false;
    private final Logger logger = LoggerFactory.getLogger(AuthenticationClient.class);
    private Client httpClient = null;
    private Client httpClientForSessionToken;
    private Client httpClientForKeyToken;

    public AuthenticationClient(String sessionUrl, String keyUrl) {
        this(sessionUrl, keyUrl, null);
    }

    public AuthenticationClient(String sessionUrl, String keyUrl, Client httpClient) {
        this.sessionUrl = sessionUrl;
        this.keyUrl = keyUrl;
        this.httpClient = httpClient;
    }

    public AuthenticationClient(SymphonyClientConfig symphonyClientConfig) {
        try {
            this.httpClient = CustomHttpClient.getClient(symphonyClientConfig.get(SymphonyClientConfigID.USER_CERT_FILE), symphonyClientConfig.get(SymphonyClientConfigID.USER_CERT_PASSWORD), symphonyClientConfig.get(SymphonyClientConfigID.TRUSTSTORE_FILE), symphonyClientConfig.get(SymphonyClientConfigID.TRUSTSTORE_PASSWORD));
        }
        catch (Exception e) {
            this.logger.error("Could not create custom http client for use...", (Throwable)e);
        }
        this.sessionUrl = symphonyClientConfig.get(SymphonyClientConfigID.SESSIONAUTH_URL);
        this.keyUrl = symphonyClientConfig.get(SymphonyClientConfigID.KEYAUTH_URL);
    }

    public AuthenticationClient(String sessionUrl, String keyUrl, Client httpClientForSessionToken, Client httpClientForKeyToken) {
        this.sessionUrl = sessionUrl;
        this.keyUrl = keyUrl;
        this.httpClientForSessionToken = httpClientForSessionToken;
        this.httpClientForKeyToken = httpClientForKeyToken;
    }

    public SymAuth authenticate() throws AuthenticationException {
        try {
            AuthenticationApi authenticationApi = this.getAuthenticationApi();
            authenticationApi.getApiClient().setBasePath(this.sessionUrl);
            if (this.httpClientForSessionToken != null) {
                Configuration.getDefaultApiClient().setHttpClient(this.httpClientForSessionToken);
            }
            this.symAuth.setSessionToken(authenticationApi.v1AuthenticatePost());
            this.logger.debug("SessionToken: {} : {}", (Object)this.symAuth.getSessionToken().getName(), (Object)this.symAuth.getSessionToken().getToken());
            authenticationApi.getApiClient().setBasePath(this.keyUrl);
            if (this.httpClientForKeyToken != null) {
                Configuration.getDefaultApiClient().setHttpClient(this.httpClientForKeyToken);
            }
            this.symAuth.setKeyToken(authenticationApi.v1AuthenticatePost());
            this.logger.debug("KeyToken: {} : {}", (Object)this.symAuth.getKeyToken().getName(), (Object)this.symAuth.getKeyToken().getToken());
        }
        catch (ApiException e) {
            throw new AuthenticationException("Please check certificates, tokens and paths.. ", e.getCode(), (Throwable)e);
        }
        this.loginStatus = true;
        return this.symAuth;
    }

    public void sessionLogout(SymAuth symAuth) throws AuthenticationException {
        try {
            AuthenticationApi authenticationApi = this.getAuthenticationApi();
            authenticationApi.getApiClient().setBasePath(this.sessionUrl);
            if (this.httpClientForSessionToken != null) {
                Configuration.getDefaultApiClient().setHttpClient(this.httpClientForSessionToken);
            }
            authenticationApi.v1LogoutPost(symAuth.getSessionToken().getToken());
            this.logger.debug("Logged out from session: {} : {}", (Object)symAuth.getSessionToken().getName(), (Object)symAuth.getSessionToken().getToken());
        }
        catch (ApiException e) {
            throw new AuthenticationException("Please check if you supplied the correct session token.. ", e.getCode(), (Throwable)e);
        }
    }

    public SymExtensionAppAuth authenticateExtensionApp(String appToken) throws AuthenticationException {
        try {
            AuthenticationApi authenticationApi = this.getAuthenticationApi();
            AuthenticateRequest authenticateRequest = new AuthenticateRequest();
            authenticateRequest.setAppToken(appToken);
            authenticationApi.getApiClient().setBasePath(this.sessionUrl);
            SymExtensionAppAuth symExtensionAppAuth = SymExtensionAppAuth.toSymExtensionAppAuth(authenticationApi.v1AuthenticateExtensionAppPost(authenticateRequest));
            this.logger.debug("SymExtensionsAppAuth- AppId: [{}] AppToken: [{}] SymToken: [{}], Expire: [{}]", new Object[]{symExtensionAppAuth.getAppId(), symExtensionAppAuth.getAppToken(), symExtensionAppAuth.getSymphonyToken(), symExtensionAppAuth.getExpireAt()});
            return symExtensionAppAuth;
        }
        catch (ApiException e) {
            throw new AuthenticationException("Please check certificates, tokens and paths.. ", e.getCode(), (Throwable)e);
        }
    }

    public SymAuth authenticateApp() throws AuthenticationException {
        SymAuth symAuth = new SymAuth();
        try {
            AuthenticationApi authenticationApi = this.getAuthenticationApi();
            authenticationApi.getApiClient().setBasePath(this.sessionUrl);
            if (this.httpClientForSessionToken != null) {
                Configuration.getDefaultApiClient().setHttpClient(this.httpClientForSessionToken);
            }
            symAuth.setSessionToken(authenticationApi.v1AppAuthenticatePost());
            this.logger.debug("App SessionToken: {} : {}", (Object)symAuth.getSessionToken().getName(), (Object)symAuth.getSessionToken().getToken());
        }
        catch (ApiException e) {
            throw new AuthenticationException("Please check certificates, tokens and paths.. ", e.getCode(), (Throwable)e);
        }
        this.loginStatus = true;
        return symAuth;
    }

    public SymAuth authenticateAppUser(SymUser symUser, SymAuth symAuth) throws AuthenticationException {
        try {
            AuthenticationApi authenticationApi = this.getAuthenticationApi();
            authenticationApi.getApiClient().setBasePath(this.sessionUrl);
            if (symUser.getId() != null) {
                return SymAuth.fromOboAuth(authenticationApi.v1AppUserUidAuthenticatePost(symUser.getId(), symAuth.getSessionToken().getToken()));
            }
            if (symUser.getUsername() != null) {
                return SymAuth.fromOboAuth(authenticationApi.v1AppUsernameUsernameAuthenticatePost(symUser.getUsername(), symAuth.getSessionToken().getToken()));
            }
            return null;
        }
        catch (ApiException e) {
            throw new AuthenticationException("Authentication of App User for OBO failed, please check certificates, tokens and paths.. ", e.getCode(), (Throwable)e);
        }
    }

    public void setKeystores(String serverTruststore, String truststorePass, String clientKeystore, String keystorePass) {
        System.setProperty("javax.net.ssl.trustStore", serverTruststore);
        if (truststorePass != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", truststorePass);
        }
        System.setProperty("javax.net.ssl.keyStore", clientKeystore);
        System.setProperty("javax.net.ssl.keyStorePassword", keystorePass);
        System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
    }

    private AuthenticationApi getAuthenticationApi() throws AuthenticationException {
        if (this.sessionUrl == null || this.keyUrl == null) {
            throw new NullPointerException("Session URL or Keystore URL is null..");
        }
        this.symAuth = new SymAuth();
        ApiClient authenticatorClient = Configuration.getDefaultApiClient();
        this.symAuth.setKeyUrl(this.keyUrl);
        this.symAuth.setSessionUrl(this.sessionUrl);
        if (this.httpClient != null) {
            authenticatorClient.setHttpClient(this.httpClient);
            this.symAuth.setHttpClient(this.httpClient);
        } else {
            this.symAuth.setServerTruststore(System.getProperty("javax.net.ssl.trustStore"));
            this.symAuth.setServerTruststorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
            this.symAuth.setClientKeystore(System.getProperty("javax.net.ssl.keyStore"));
            this.symAuth.setClientKeystorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        return new AuthenticationApi(authenticatorClient);
    }

    public boolean isLoggedIn() {
        return this.loginStatus;
    }

    public Token getKeyToken() {
        return this.symAuth.getKeyToken();
    }

    public void setKeyToken(Token keyToken) {
        this.symAuth.setKeyToken(keyToken);
    }

    public Token getSessionToken() {
        return this.symAuth.getSessionToken();
    }

    public void setSessionToken(Token sessionToken) {
        this.symAuth.setSessionToken(sessionToken);
    }
}

