/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.SystemException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.agent.api.SystemApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.clients.AgentSystemClient;
import org.symphonyoss.symphony.clients.model.RestApiVersion;
import org.symphonyoss.symphony.clients.model.SymAgentHealthCheck;

public class AgentSystemClientImpl
implements AgentSystemClient {
    private final ApiClient apiClient;
    private final SymAuth symAuth;
    private Logger logger = LoggerFactory.getLogger(AgentSystemClientImpl.class);
    private String restApiVersion;

    public AgentSystemClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    public AgentSystemClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    @Override
    public SymAgentHealthCheck getAgentHealthCheck() throws SystemException {
        SystemApi systemApi = new SystemApi(this.apiClient);
        try {
            return SymAgentHealthCheck.toSymAgentHealthCheck(systemApi.v2HealthCheckGet(this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken()));
        }
        catch (ApiException e) {
            throw new SystemException("Could not execute health check on agent server", e);
        }
    }

    @Override
    public boolean isRestApiVersionCompatible(RestApiVersion apiVersion) throws SystemException {
        if (this.restApiVersion == null) {
            this.restApiVersion = this.getAgentHealthCheck().getAgentVersion();
        }
        return apiVersion.isCompatible(this.restApiVersion);
    }
}

