/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.io.File;
import java.util.Base64;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.AttachmentsException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.agent.api.AttachmentsApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.agent.model.AttachmentInfo;
import org.symphonyoss.symphony.clients.AttachmentsClient;
import org.symphonyoss.symphony.clients.model.SymAttachmentInfo;
import org.symphonyoss.symphony.clients.model.SymMessage;

public class AttachmentsClientImpl
implements AttachmentsClient {
    private final ApiClient apiClient;
    private final SymAuth symAuth;
    private Logger logger = LoggerFactory.getLogger(AttachmentsClientImpl.class);

    public AttachmentsClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public AttachmentsClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    @Override
    public byte[] getAttachmentData(SymAttachmentInfo symAttachmentInfo, SymMessage symMessage) throws AttachmentsException {
        AttachmentsApi attachmentsApi = new AttachmentsApi(this.apiClient);
        if (symAttachmentInfo.getId() == null || symMessage.getId() == null || symMessage.getStreamId() == null) {
            throw new NullPointerException("Null values detected for attachments information or streamId");
        }
        try {
            return Base64.getDecoder().decode(attachmentsApi.v1StreamSidAttachmentGet(symMessage.getStreamId(), symAttachmentInfo.getId(), symMessage.getId(), this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken()));
        }
        catch (ApiException e) {
            throw new AttachmentsException("Could not retrieve or decode attachment from POD..", e);
        }
    }

    @Override
    public SymAttachmentInfo postAttachment(String sid, File attachment) throws AttachmentsException {
        AttachmentInfo attachmentInfo;
        AttachmentsApi attachmentsApi = new AttachmentsApi(this.apiClient);
        if (sid == null || attachment == null) {
            throw new NullPointerException("Either stream ID or file is null..");
        }
        try {
            attachmentInfo = attachmentsApi.v3StreamSidAttachmentCreatePost(sid, this.symAuth.getSessionToken().getToken(), attachment, this.symAuth.getKeyToken().getToken());
        }
        catch (ApiException e) {
            throw new AttachmentsException("Failed to post attachment for file " + attachment.getName(), e);
        }
        if (attachmentInfo == null) {
            throw new AttachmentsException("Failed to post attachment.  Posting results returned no information.");
        }
        return SymAttachmentInfo.toAttachmentInfo(attachmentInfo);
    }
}

