/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.ConnectionsException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.clients.ConnectionsClient;
import org.symphonyoss.symphony.clients.model.SymUser;
import org.symphonyoss.symphony.clients.model.SymUserConnection;
import org.symphonyoss.symphony.clients.model.SymUserConnectionRequest;
import org.symphonyoss.symphony.pod.api.ConnectionApi;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.model.UserConnectionList;
import org.symphonyoss.symphony.pod.model.UserConnectionRequest;

public class ConnectionsClientImpl
implements ConnectionsClient {
    private final ApiClient apiClient;
    private final SymAuth symAuth;

    public ConnectionsClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public ConnectionsClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
    }

    @Override
    public List<SymUserConnection> getIncomingRequests() throws ConnectionsException {
        return this.getAllConnections(SymUserConnection.Status.PENDING_INCOMING, null);
    }

    @Override
    public List<SymUserConnection> getPendingRequests() throws ConnectionsException {
        return this.getAllConnections(SymUserConnection.Status.PENDING_OUTGOING, null);
    }

    @Override
    public List<SymUserConnection> getRejectedRequests() throws ConnectionsException {
        return this.getAllConnections(SymUserConnection.Status.REJECTED, null);
    }

    @Override
    public List<SymUserConnection> getAcceptedRequests() throws ConnectionsException {
        return this.getAllConnections(SymUserConnection.Status.ACCEPTED, null);
    }

    @Override
    public List<SymUserConnection> getAllConnections() throws ConnectionsException {
        return this.getAllConnections(SymUserConnection.Status.ALL, null);
    }

    @Override
    public void removeConnectionRequest(SymUser symUser) throws ConnectionsException {
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        if (symUser == null) {
            throw new NullPointerException("Symphony user was not provided.");
        }
        try {
            connectionApi.v1ConnectionUserUidRemovePost(this.symAuth.getSessionToken().getToken(), symUser.getId());
        }
        catch (ApiException e) {
            throw new ConnectionsException("Error removing connected user: " + symUser.getId(), e);
        }
    }

    @Override
    public SymUserConnection sendConnectionRequest(SymUserConnectionRequest symUserConnectionRequest) throws ConnectionsException {
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        if (symUserConnectionRequest == null) {
            throw new NullPointerException("Connection request was not provided.");
        }
        try {
            return SymUserConnection.toSymUserConnection(connectionApi.v1ConnectionCreatePost(this.symAuth.getSessionToken().getToken(), (UserConnectionRequest)symUserConnectionRequest));
        }
        catch (ApiException e) {
            throw new ConnectionsException("Error sending connection request to ID: " + symUserConnectionRequest.getUserId(), e);
        }
    }

    @Override
    public SymUserConnection acceptConnectionRequest(SymUserConnectionRequest symUserConnectionRequest) throws ConnectionsException {
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        if (symUserConnectionRequest == null) {
            throw new NullPointerException("Connection request was not provided.");
        }
        try {
            return SymUserConnection.toSymUserConnection(connectionApi.v1ConnectionAcceptPost(this.symAuth.getSessionToken().getToken(), (UserConnectionRequest)symUserConnectionRequest));
        }
        catch (ApiException e) {
            throw new ConnectionsException("Failed to accept connection request from ID: " + symUserConnectionRequest.getUserId(), e);
        }
    }

    @Override
    public SymUserConnection acceptConnectionRequest(SymUserConnection symUserConnection) throws ConnectionsException {
        if (symUserConnection == null) {
            throw new NullPointerException("SymUserConnection was not provided.. ");
        }
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        try {
            return SymUserConnection.toSymUserConnection(connectionApi.v1ConnectionAcceptPost(this.symAuth.getSessionToken().getToken(), (UserConnectionRequest)new SymUserConnectionRequest(symUserConnection)));
        }
        catch (ApiException e) {
            throw new ConnectionsException("Failed to accept connection request from ID: " + symUserConnection.getUserId(), e);
        }
    }

    @Override
    public SymUserConnection rejectConnectionRequest(SymUserConnectionRequest symUserConnectionRequest) throws ConnectionsException {
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        if (symUserConnectionRequest == null) {
            throw new NullPointerException("Connection request was not provided.");
        }
        try {
            return SymUserConnection.toSymUserConnection(connectionApi.v1ConnectionRejectPost(this.symAuth.getSessionToken().getToken(), (UserConnectionRequest)symUserConnectionRequest));
        }
        catch (ApiException e) {
            throw new ConnectionsException("Failed to reject connection request from ID: " + symUserConnectionRequest.getUserId(), e);
        }
    }

    @Override
    @Deprecated
    public SymUserConnection getUserConnection(String userId) throws ConnectionsException {
        if (userId == null) {
            throw new NullPointerException("UserID was not provided..");
        }
        SymUser symUser = new SymUser();
        symUser.setId(Long.valueOf(userId));
        return this.getUserConnection(symUser);
    }

    @Override
    public SymUserConnection getUserConnection(SymUser symUser) throws ConnectionsException {
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        if (symUser == null) {
            throw new NullPointerException("SymUser was not provided..");
        }
        try {
            return SymUserConnection.toSymUserConnection(connectionApi.v1ConnectionUserUserIdInfoGet(this.symAuth.getSessionToken().getToken(), symUser.getId().toString()));
        }
        catch (ApiException e) {
            throw new ConnectionsException("Unable to retrieve connection information for ID: " + symUser.getId(), e);
        }
    }

    private List<SymUserConnection> getAllConnections(SymUserConnection.Status status, String userIds) throws ConnectionsException {
        UserConnectionList userConnectionList;
        ConnectionApi connectionApi = new ConnectionApi(this.apiClient);
        SymUserConnection.Status theStatus = status;
        if (theStatus == null) {
            theStatus = SymUserConnection.Status.ALL;
        }
        try {
            userConnectionList = connectionApi.v1ConnectionListGet(this.symAuth.getSessionToken().getToken(), theStatus.toString(), userIds);
        }
        catch (ApiException e) {
            throw new ConnectionsException("Unable to retrieve all known connections..", e);
        }
        return userConnectionList.stream().map(SymUserConnection::toSymUserConnection).collect(Collectors.toList());
    }
}

