/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.util.List;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.events.SymEvent;
import org.symphonyoss.client.exceptions.DataFeedException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.agent.api.DatafeedApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.agent.model.V4Event;
import org.symphonyoss.symphony.agent.model.V4EventList;
import org.symphonyoss.symphony.clients.DataFeedClient;
import org.symphonyoss.symphony.clients.model.ApiVersion;
import org.symphonyoss.symphony.clients.model.SymDatafeed;

public class DataFeedClientImpl
implements DataFeedClient {
    private final ApiClient apiClient;
    private final SymAuth symAuth;
    private Logger logger = LoggerFactory.getLogger(DataFeedClientImpl.class);

    public DataFeedClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public DataFeedClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    @Override
    public SymDatafeed createDatafeed(ApiVersion apiVersion) throws DataFeedException {
        DatafeedApi datafeedApi = new DatafeedApi(this.apiClient);
        try {
            return SymDatafeed.toSymDatafeed(datafeedApi.v4DatafeedCreatePost(this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken()));
        }
        catch (ApiException e) {
            throw new DataFeedException("Could not start datafeed..", datafeedApi.getApiClient().getBasePath(), e.getCode(), e);
        }
        catch (RuntimeException ef) {
            throw new DataFeedException("Could not start datafeed due to network issue..", datafeedApi.getApiClient().getBasePath(), 500, ef);
        }
    }

    @Override
    public List<SymEvent> getEventsFromDatafeed(SymDatafeed datafeed, int maxMessages) throws DataFeedException {
        DatafeedApi datafeedApi = new DatafeedApi(this.apiClient);
        if (datafeed == null) {
            throw new NullPointerException("Datafeed was not provided and null..");
        }
        try {
            V4EventList v4Events = datafeedApi.v4DatafeedIdReadGet(datafeed.getId(), this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken(), Integer.valueOf(maxMessages));
            return SymEvent.toSymEvent((List<V4Event>)v4Events);
        }
        catch (ApiException e) {
            throw new DataFeedException("Failed to retrieve messages from datafeed...", datafeedApi.getApiClient().getBasePath(), e.getCode(), e);
        }
        catch (RuntimeException ef) {
            throw new DataFeedException("Failed to retrieve messages due to network issue..", datafeedApi.getApiClient().getBasePath(), 500, ef);
        }
    }

    @Override
    public List<SymEvent> getEventsFromDatafeed(SymDatafeed datafeed) throws DataFeedException {
        return this.getEventsFromDatafeed(datafeed, Integer.parseInt(System.getProperty("datafeed.max.messages", "100")));
    }
}

