/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.util.List;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.events.SymEvent;
import org.symphonyoss.client.exceptions.DataFeedException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.agent.api.FirehoseApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.agent.model.V5EventList;
import org.symphonyoss.symphony.clients.FirehoseClient;
import org.symphonyoss.symphony.clients.model.SymFirehose;
import org.symphonyoss.symphony.clients.model.SymFirehoseRequest;

public class FirehoseClientImpl
implements FirehoseClient {
    private final ApiClient apiClient;
    private final SymAuth symAuth;
    private Logger logger = LoggerFactory.getLogger(FirehoseClientImpl.class);

    public FirehoseClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public FirehoseClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    @Override
    public SymFirehose createFirehose() throws DataFeedException {
        FirehoseApi firehoseApi = new FirehoseApi(this.apiClient);
        try {
            return SymFirehose.toSymFirehose(firehoseApi.v5FirehoseCreatePost(this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken()));
        }
        catch (ApiException e) {
            throw new DataFeedException("Could not start firehose..", firehoseApi.getApiClient().getBasePath(), e.getCode(), e);
        }
        catch (RuntimeException ef) {
            throw new DataFeedException("Could not start firehose due to network issue..", firehoseApi.getApiClient().getBasePath(), 500, ef);
        }
    }

    @Override
    public List<SymEvent> getEventsFromFirehose(SymFirehose symFirehose, SymFirehoseRequest symFirehoseRequest) throws DataFeedException {
        FirehoseApi firehoseApi = new FirehoseApi(this.apiClient);
        try {
            V5EventList v5EventList = firehoseApi.v5FirehoseIdReadPost(symFirehose.getId(), this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken(), SymFirehoseRequest.toV5FirehoseRequest(symFirehoseRequest));
            return SymEvent.toSymEvent(v5EventList.getEvents());
        }
        catch (ApiException e) {
            throw new DataFeedException("Failed to retrieve messages from firehose...", firehoseApi.getApiClient().getBasePath(), e.getCode(), e);
        }
        catch (RuntimeException ef) {
            throw new DataFeedException("Failed to retrieve messages due to network issue..", firehoseApi.getApiClient().getBasePath(), 500, ef);
        }
    }
}

