/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.MessagesException;
import org.symphonyoss.client.exceptions.RestException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.agent.api.MessagesApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.agent.model.V2BaseMessage;
import org.symphonyoss.symphony.agent.model.V2Message;
import org.symphonyoss.symphony.agent.model.V2MessageList;
import org.symphonyoss.symphony.agent.model.V2MessageSubmission;
import org.symphonyoss.symphony.agent.model.V4MessageList;
import org.symphonyoss.symphony.clients.MessagesClient;
import org.symphonyoss.symphony.clients.model.ApiVersion;
import org.symphonyoss.symphony.clients.model.SymAttachmentInfo;
import org.symphonyoss.symphony.clients.model.SymMessage;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.pod.model.Stream;

public class MessagesClientImpl
implements MessagesClient {
    private final ApiClient apiClient;
    private final SymAuth symAuth;
    private Logger logger = LoggerFactory.getLogger(MessagesClientImpl.class);

    public MessagesClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public MessagesClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.getHttpClient().register(MultiPartFeature.class);
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    @Override
    @Deprecated
    public SymMessage sendMessage(Stream stream, SymMessage message) throws MessagesException {
        return this.sendMessage(SymStream.toSymStream(stream), message);
    }

    @Override
    public SymMessage sendMessage(SymStream stream, SymMessage message, SymAuth symAuth) throws MessagesException {
        return this.sendMessageV4(stream, message, symAuth);
    }

    @Override
    public SymMessage sendMessage(SymStream stream, SymMessage message) throws MessagesException {
        switch (message.getApiVersion()) {
            case V3: {
                return this.sendMessageV3(stream, message);
            }
            case V4: {
                return this.sendMessageV4(stream, message);
            }
        }
        return this.sendMessageV2(stream, message);
    }

    @Override
    public List<SymMessage> getMessagesFromStream(SymStream symStream, Long since, Integer offset, Integer maxMessages, ApiVersion apiVersion1) throws MessagesException {
        return ApiVersion.V4 == apiVersion1 ? this.getMessagesFromStreamV4(symStream, since, offset, maxMessages) : this.getMessagesFromStreamV2(symStream, since, offset, maxMessages);
    }

    @Override
    public List<SymMessage> getMessagesFromStream(SymStream symStream, Long since, Integer offset, Integer maxMessages) throws MessagesException {
        return this.getMessagesFromStreamV4(symStream, since, offset, maxMessages);
    }

    @Override
    public List<SymMessage> getMessagesFromStream(Stream stream, Long since, Integer offset, Integer maxMessages) throws MessagesException {
        return this.getMessagesFromStream(SymStream.toSymStream(stream), since, offset, maxMessages);
    }

    private List<SymMessage> getMessagesFromStreamV4(SymStream stream, Long since, Integer offset, Integer maxMessages) throws MessagesException {
        V4MessageList v4MessageList;
        if (stream == null) {
            throw new NullPointerException("Stream submission was not provided..");
        }
        MessagesApi messagesApi = new MessagesApi(this.apiClient);
        try {
            v4MessageList = messagesApi.v4StreamSidMessageGet(stream.getStreamId(), since, this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken(), offset, maxMessages);
        }
        catch (ApiException e) {
            throw new MessagesException("Failed to retrieve messages from SymStream: " + stream, new RestException(messagesApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        ArrayList<SymMessage> symMessageList = new ArrayList<SymMessage>();
        if (v4MessageList != null) {
            symMessageList.addAll(v4MessageList.stream().map(SymMessage::toSymMessage).collect(Collectors.toList()));
        }
        return symMessageList;
    }

    private List<SymMessage> getMessagesFromStreamV2(SymStream stream, Long since, Integer offset, Integer maxMessages) throws MessagesException {
        V2MessageList v2MessageList;
        if (stream == null) {
            throw new NullPointerException("Stream submission was not provided..");
        }
        MessagesApi messagesApi = new MessagesApi(this.apiClient);
        try {
            v2MessageList = messagesApi.v2StreamSidMessageGet(stream.getStreamId(), since, this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken(), offset, maxMessages);
        }
        catch (ApiException e) {
            throw new MessagesException("Failed to retrieve messages from stream: " + stream, new RestException(messagesApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
        ArrayList<SymMessage> symMessageList = new ArrayList<SymMessage>();
        if (v2MessageList != null) {
            symMessageList.addAll(v2MessageList.stream().filter(v2BaseMessage -> v2BaseMessage instanceof V2Message).map(SymMessage::toSymMessage).collect(Collectors.toList()));
        }
        return symMessageList;
    }

    private SymMessage sendMessageV4(SymStream stream, SymMessage message) throws MessagesException {
        return this.sendMessageV4(stream, message, null);
    }

    private SymMessage sendMessageV4(SymStream stream, SymMessage message, SymAuth altSymAuth) throws MessagesException {
        if (stream == null || message == null) {
            throw new NullPointerException("Stream or message submission was not provided..");
        }
        String sessionToken = this.symAuth.getSessionToken().getToken();
        if (altSymAuth != null && altSymAuth.getSessionToken() != null) {
            sessionToken = altSymAuth.getSessionToken().getToken();
        }
        MessagesApi messagesApi = new MessagesApi(this.apiClient);
        try {
            return SymMessage.toSymMessage(messagesApi.v4StreamSidMessageCreatePost(stream.getStreamId(), sessionToken, this.symAuth.getKeyToken().getToken(), message.getMessage(), message.getEntityData(), ApiVersion.V4.toString(), message.getAttachment(), message.getAttachementThumbnail()));
        }
        catch (ApiException e) {
            throw new MessagesException("Failed to send message to stream: " + stream.getStreamId(), new RestException(messagesApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
    }

    private SymMessage sendMessageV2(SymStream stream, SymMessage message) throws MessagesException {
        if (stream == null || message == null) {
            throw new NullPointerException("Stream or message submission was not provided..");
        }
        MessagesApi messagesApi = new MessagesApi(this.apiClient);
        V2MessageSubmission messageSubmission = new V2MessageSubmission();
        messageSubmission.setMessage(message.getMessage());
        messageSubmission.setFormat(V2MessageSubmission.FormatEnum.MESSAGEML);
        messageSubmission.setAttachments(SymAttachmentInfo.toV2AttachmentsInfo(message.getAttachments()));
        try {
            return SymMessage.toSymMessage((V2BaseMessage)messagesApi.v2StreamSidMessageCreatePost(stream.getStreamId(), this.symAuth.getSessionToken().getToken(), this.symAuth.getKeyToken().getToken(), messageSubmission));
        }
        catch (ApiException e) {
            throw new MessagesException("Failed to send message to stream: " + stream.getStreamId() + ": " + message.getMessage(), new RestException(messagesApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
    }

    private SymMessage sendMessageV3(SymStream stream, SymMessage message) throws MessagesException {
        if (stream == null || message == null) {
            throw new NullPointerException("Stream or message submission was not provided..");
        }
        MessagesApi messagesApi = new MessagesApi(this.apiClient);
        V2MessageSubmission messageSubmission = this.getV2MessageSubmission(message);
        try {
            return SymMessage.toSymMessage((V2BaseMessage)messagesApi.v3StreamSidMessageCreatePost(stream.getStreamId(), this.symAuth.getSessionToken().getToken(), messageSubmission, this.symAuth.getKeyToken().getToken()));
        }
        catch (ApiException e) {
            throw new MessagesException("Failed to send message to stream: " + stream.getStreamId() + ": " + message.getMessage(), new RestException(messagesApi.getApiClient().getBasePath(), e.getCode(), (Throwable)e));
        }
    }

    private V2MessageSubmission getV2MessageSubmission(SymMessage message) {
        V2MessageSubmission messageSubmission = new V2MessageSubmission();
        messageSubmission.setMessage(message.getMessage());
        messageSubmission.setFormat(V2MessageSubmission.FormatEnum.MESSAGEML);
        messageSubmission.setAttachments(SymAttachmentInfo.toV2AttachmentsInfo(message.getAttachments()));
        return messageSubmission;
    }
}

