/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.util.List;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.PresenceException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.clients.PresenceClient;
import org.symphonyoss.symphony.clients.model.SymPresence;
import org.symphonyoss.symphony.clients.model.SymPresenceFeed;
import org.symphonyoss.symphony.clients.model.SymUser;
import org.symphonyoss.symphony.pod.api.PresenceApi;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.model.V2PresenceStatus;

public class PresenceClientImpl
implements PresenceClient {
    private final SymAuth symAuth;
    private final ApiClient apiClient;
    private Logger logger = LoggerFactory.getLogger(PresenceClientImpl.class);

    public PresenceClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public PresenceClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
    }

    @Override
    public SymPresence getUserPresence(Long userId, Boolean local) throws PresenceException {
        SymUser symUser = new SymUser();
        symUser.setId(userId);
        return this.getUserPresence(symUser, local);
    }

    @Override
    public SymPresence getUserPresence(SymUser symUser, Boolean local) throws PresenceException {
        PresenceApi presenceApi = new PresenceApi(this.apiClient);
        if (symUser == null || symUser.getId() == null) {
            throw new NullPointerException("UserId was not provided...");
        }
        try {
            return SymPresence.toSymPresence(presenceApi.v2UserUidPresenceGet(symUser.getId(), this.symAuth.getSessionToken().getToken(), local));
        }
        catch (ApiException e) {
            throw new PresenceException("Failed to retrieve user presence for ID: " + symUser.getId(), e);
        }
    }

    @Override
    public SymPresenceFeed createPresenceFeed() throws PresenceException {
        PresenceApi presenceApi = new PresenceApi(this.apiClient);
        try {
            return SymPresenceFeed.toSymPresenceFeed(presenceApi.v1PresenceFeedCreatePost(this.symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new PresenceException("Failed to retrieve presence ID..", e);
        }
    }

    @Override
    public void removePresenceFeed(SymPresenceFeed symPresenceFeed) throws PresenceException {
        if (symPresenceFeed == null || symPresenceFeed.getId() == null) {
            throw new NullPointerException("SymPresence was null...");
        }
        PresenceApi presenceApi = new PresenceApi(this.apiClient);
        try {
            presenceApi.v1PresenceFeedFeedIdDeletePost(this.symAuth.getSessionToken().getToken(), symPresenceFeed.getId());
        }
        catch (ApiException e) {
            throw new PresenceException("Failed to remove presence ID..", e);
        }
    }

    @Override
    public List<SymPresence> getPresenceFeedUpdates(SymPresenceFeed symPresenceFeed) throws PresenceException {
        if (symPresenceFeed == null || symPresenceFeed.getId() == null) {
            return null;
        }
        PresenceApi presenceApi = new PresenceApi(this.apiClient);
        try {
            return SymPresence.toSymPresence(presenceApi.v1PresenceFeedFeedIdReadGet(this.symAuth.getSessionToken().getToken(), symPresenceFeed.getId()));
        }
        catch (ApiException e) {
            throw new PresenceException("Failed to remove presence ID..", e);
        }
    }

    @Override
    public SymPresence setUserPresence(SymPresence presence) throws PresenceException {
        if (presence == null) {
            return null;
        }
        PresenceApi presenceApi = new PresenceApi(this.apiClient);
        try {
            V2PresenceStatus v2PresenceStatus = new V2PresenceStatus();
            v2PresenceStatus.setCategory(presence.getCategory().toString());
            return SymPresence.toSymPresence(presenceApi.v2UserPresencePost(this.symAuth.getSessionToken().getToken(), v2PresenceStatus));
        }
        catch (ApiException e) {
            throw new PresenceException("Failed to set presence for user.", e);
        }
    }
}

