/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import com.google.common.base.Strings;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.SymException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.clients.RoomMembershipClient;
import org.symphonyoss.symphony.pod.api.RoomMembershipApi;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.model.MembershipList;
import org.symphonyoss.symphony.pod.model.UserId;

public class RoomMembershipClientImpl
implements RoomMembershipClient {
    private final SymAuth symAuth;
    private final ApiClient apiClient;
    private Logger logger = LoggerFactory.getLogger(RoomMembershipClientImpl.class);

    public RoomMembershipClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public RoomMembershipClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
        this.apiClient.addDefaultHeader(symAuth.getSessionToken().getName(), symAuth.getSessionToken().getToken());
        this.apiClient.addDefaultHeader(symAuth.getKeyToken().getName(), symAuth.getKeyToken().getToken());
    }

    @Override
    public MembershipList getRoomMembership(String roomStreamId) throws SymException {
        if (roomStreamId == null) {
            throw new NullPointerException("Room ID was not provided...");
        }
        RoomMembershipApi roomMembershipApi = new RoomMembershipApi(this.apiClient);
        try {
            return roomMembershipApi.v1RoomIdMembershipListGet(roomStreamId, this.symAuth.getSessionToken().getToken());
        }
        catch (ApiException e) {
            throw new SymException("Failed to retrieve room membership for room ID: " + roomStreamId, e);
        }
    }

    @Override
    public void addMemberToRoom(String roomStreamId, long userId) throws SymException {
        if (Strings.isNullOrEmpty((String)roomStreamId)) {
            throw new IllegalArgumentException("Argument roomStreamId must not be empty or null");
        }
        RoomMembershipApi roomMembershipApi = new RoomMembershipApi(this.apiClient);
        String sessionToken = this.symAuth.getSessionToken().getToken();
        try {
            if (Strings.isNullOrEmpty((String)sessionToken)) {
                throw new IllegalStateException("Invalid session token. It must not be null or empty");
            }
            roomMembershipApi.v1RoomIdMembershipAddPost(roomStreamId, new UserId().id(Long.valueOf(userId)), sessionToken);
        }
        catch (ApiException e) {
            throw new SymException("Symphony API exception adding member to room.", e);
        }
    }

    @Override
    public void removeMemberFromRoom(String roomStreamId, long userId) throws SymException {
        if (Strings.isNullOrEmpty((String)roomStreamId)) {
            throw new IllegalArgumentException("Argument roomStreamId must not be empty or null");
        }
        RoomMembershipApi roomMembershipApi = new RoomMembershipApi(this.apiClient);
        String sessionToken = this.symAuth.getSessionToken().getToken();
        try {
            if (Strings.isNullOrEmpty((String)sessionToken)) {
                throw new IllegalStateException("Invalid session token. It must not be null or empty");
            }
            roomMembershipApi.v1RoomIdMembershipRemovePost(roomStreamId, new UserId().id(Long.valueOf(userId)), sessionToken);
        }
        catch (ApiException e) {
            throw new SymException("Symphony API exception removing member from room.", e);
        }
    }
}

