/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import javax.ws.rs.client.Client;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.ShareException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.client.model.SymShareArticle;
import org.symphonyoss.symphony.agent.api.ShareApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.agent.invoker.ApiException;
import org.symphonyoss.symphony.agent.invoker.Configuration;
import org.symphonyoss.symphony.agent.model.ShareContent;
import org.symphonyoss.symphony.clients.ShareClient;

public class ShareClientImpl
implements ShareClient {
    private final SymAuth symAuth;
    private final ApiClient apiClient;

    public ShareClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public ShareClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
    }

    @Override
    public void shareArticle(String streamId, SymShareArticle article) throws ShareException {
        ShareApi shareApi = new ShareApi(this.apiClient);
        ShareContent shareContent = new ShareContent();
        shareContent.setContent(SymShareArticle.toShareArticle(article));
        shareContent.setType("com.symphony.sharing.article");
        try {
            shareApi.v3StreamSidSharePost(streamId, this.symAuth.getSessionToken().getToken(), shareContent, this.symAuth.getKeyToken().getToken());
        }
        catch (ApiException e) {
            throw new ShareException(e);
        }
    }
}

