/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.StreamsException;
import org.symphonyoss.client.exceptions.UsersClientException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.clients.StreamsClient;
import org.symphonyoss.symphony.clients.UsersClient;
import org.symphonyoss.symphony.clients.UsersFactory;
import org.symphonyoss.symphony.clients.model.SymAdminStreamFilter;
import org.symphonyoss.symphony.clients.model.SymAdminStreamList;
import org.symphonyoss.symphony.clients.model.SymRoomAttributes;
import org.symphonyoss.symphony.clients.model.SymRoomDetail;
import org.symphonyoss.symphony.clients.model.SymRoomSearchCriteria;
import org.symphonyoss.symphony.clients.model.SymRoomSearchResults;
import org.symphonyoss.symphony.clients.model.SymStream;
import org.symphonyoss.symphony.clients.model.SymStreamAttributes;
import org.symphonyoss.symphony.clients.model.SymStreamFilter;
import org.symphonyoss.symphony.clients.model.SymUser;
import org.symphonyoss.symphony.pod.api.StreamsApi;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;
import org.symphonyoss.symphony.pod.model.AdminStreamFilter;
import org.symphonyoss.symphony.pod.model.AdminStreamList;
import org.symphonyoss.symphony.pod.model.StreamAttributes;
import org.symphonyoss.symphony.pod.model.StreamFilter;
import org.symphonyoss.symphony.pod.model.StreamList;
import org.symphonyoss.symphony.pod.model.UserIdList;

public class StreamsClientImpl
implements StreamsClient {
    private final SymAuth symAuth;
    private final SymphonyClientConfig config;
    private final ApiClient apiClient;
    private final Logger logger = LoggerFactory.getLogger(StreamsClientImpl.class);

    public StreamsClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public StreamsClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.config = config;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
    }

    @Override
    public SymStream getStream(SymUser symUser) throws StreamsException {
        if (symUser == null) {
            throw new NullPointerException("User was not provided...");
        }
        UserIdList userIdList = new UserIdList();
        userIdList.add((Object)symUser.getId());
        SymStream stream = this.getStream(userIdList);
        this.logger.debug("Stream ID for one to one chat: {}:{} ", (Object)symUser.getEmailAddress(), (Object)stream.getStreamId());
        return stream;
    }

    @Override
    public SymStream getStream(Set<SymUser> symUsers) throws StreamsException {
        if (symUsers == null) {
            throw new NullPointerException("Users were not provided...");
        }
        UserIdList userIdList = new UserIdList();
        StringBuilder usersPrint = new StringBuilder();
        for (SymUser user : symUsers) {
            userIdList.add((Object)user.getId());
            usersPrint.append(" [").append(user.getEmailAddress()).append("] ");
        }
        SymStream stream = this.getStream(userIdList);
        this.logger.debug("Stream ID for chat: {}:{} ", (Object)usersPrint.toString(), (Object)stream.getStreamId());
        return stream;
    }

    @Override
    public SymStream getStream(UserIdList userIdList) throws StreamsException {
        if (userIdList == null) {
            throw new NullPointerException("UsersIds were not provided...");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            return SymStream.toSymStream(streamsApi.v1ImCreatePost(userIdList, this.symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to retrieve stream for given user ids...", e);
        }
    }

    @Override
    public SymAdminStreamList getStreams(Integer skip, Integer limit, SymAdminStreamFilter symAdminStreamFilter) throws StreamsException {
        if (symAdminStreamFilter == null) {
            throw new NullPointerException("NO filter provided ...");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            AdminStreamFilter filter = SymAdminStreamFilter.toAdminStreamFilter(symAdminStreamFilter);
            AdminStreamList adminStreamList = streamsApi.v1AdminStreamsListPost(this.symAuth.getSessionToken().getToken(), skip, limit, filter);
            return SymAdminStreamList.toSymStreamList(adminStreamList);
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to retrieve stream for given user ids...", e);
        }
    }

    @Override
    public List<SymStreamAttributes> getStreams(Integer skip, Integer limit, SymStreamFilter symStreamFilter) throws StreamsException {
        if (symStreamFilter == null) {
            throw new NullPointerException("NO filter provided ...");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            StreamFilter filter = SymStreamFilter.toStreamFilter(symStreamFilter);
            StreamList streamList = streamsApi.v1StreamsListPost(this.symAuth.getSessionToken().getToken(), skip, limit, filter);
            ArrayList<SymStreamAttributes> symStreamAttributes = new ArrayList<SymStreamAttributes>();
            for (StreamAttributes streamAttributes : streamList) {
                symStreamAttributes.add(SymStreamAttributes.toStreamAttributes(streamAttributes));
            }
            return symStreamAttributes;
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to retrieve stream for given user ids...", e);
        }
    }

    @Override
    public SymStream getStreamFromEmail(String email) throws StreamsException {
        if (email == null) {
            throw new NullPointerException("Email was not provided...");
        }
        UsersClient usersClient = UsersFactory.getClient(this.symAuth, this.config, this.apiClient.getHttpClient());
        try {
            return this.getStream(usersClient.getUserFromEmail(email));
        }
        catch (UsersClientException e) {
            throw new StreamsException("Failed to find user from email : " + email, e);
        }
    }

    @Override
    public SymRoomDetail getRoomDetail(String roomId) throws StreamsException {
        if (roomId == null) {
            throw new NullPointerException("Room ID was not provided..");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            return SymRoomDetail.toSymRoomDetail(streamsApi.v3RoomIdInfoGet(roomId, this.symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to obtain room information from ID: " + roomId, e);
        }
    }

    @Override
    public SymRoomDetail createChatRoom(SymRoomAttributes roomAttributes) throws StreamsException {
        if (roomAttributes == null) {
            throw new NullPointerException("Room Attributes were not provided..");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            return SymRoomDetail.toSymRoomDetail(streamsApi.v3RoomCreatePost(SymRoomAttributes.toV3RoomAttributes(roomAttributes), this.symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to obtain room information while creating room: " + roomAttributes.getName(), e);
        }
    }

    @Override
    public SymRoomDetail updateChatRoom(String streamId, SymRoomAttributes roomAttributes) throws StreamsException {
        if (roomAttributes == null) {
            throw new NullPointerException("Room Attributes were not provided..");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            return SymRoomDetail.toSymRoomDetail(streamsApi.v3RoomIdUpdatePost(streamId, SymRoomAttributes.toV3RoomAttributes(roomAttributes), this.symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to obtain room information while updating attributes on room: " + roomAttributes.getName(), e);
        }
    }

    @Override
    public SymRoomSearchResults roomSearch(SymRoomSearchCriteria searchCriteria, Integer skip, Integer limit) throws StreamsException {
        if (searchCriteria == null) {
            throw new NullPointerException("Room search criteria was not provided..");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            return SymRoomSearchResults.toSymRoomSearchResults(streamsApi.v3RoomSearchPost(this.symAuth.getSessionToken().getToken(), SymRoomSearchCriteria.toRoomSearchCriteria(searchCriteria), skip, limit));
        }
        catch (ApiException e) {
            throw new StreamsException("Failed room search...", e);
        }
    }

    @Override
    public SymStreamAttributes getStreamAttributes(String streamId) throws StreamsException {
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            return SymStreamAttributes.toStreamAttributes(streamsApi.v1StreamsSidInfoGet(streamId, this.symAuth.getSessionToken().getToken()));
        }
        catch (ApiException e) {
            throw new StreamsException("Failed to obtain stream attributes while updating attributes on stream: {}" + streamId, e);
        }
    }

    @Override
    public void deactivateRoom(String roomId) throws StreamsException {
        if (roomId == null) {
            throw new IllegalArgumentException("Argument roomId must not be null");
        }
        StreamsApi streamsApi = new StreamsApi(this.apiClient);
        try {
            String sessionToken = this.symAuth.getSessionToken().getToken();
            streamsApi.v1RoomIdSetActivePost(roomId, Boolean.valueOf(false), sessionToken);
        }
        catch (Exception e) {
            String message = "Failed to deactivate room for roomId: " + roomId;
            this.logger.error(message, (Throwable)e);
            throw new StreamsException(message, e);
        }
    }
}

