/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.agent.api.AttachmentsApi;
import org.symphonyoss.symphony.agent.api.DatafeedApi;
import org.symphonyoss.symphony.agent.api.MessagesApi;
import org.symphonyoss.symphony.agent.api.ShareApi;
import org.symphonyoss.symphony.agent.api.SystemApi;
import org.symphonyoss.symphony.agent.invoker.ApiClient;
import org.symphonyoss.symphony.clients.SymphonyApis;
import org.symphonyoss.symphony.pod.api.AppEntitlementApi;
import org.symphonyoss.symphony.pod.api.ApplicationApi;
import org.symphonyoss.symphony.pod.api.ConnectionApi;
import org.symphonyoss.symphony.pod.api.DisclaimerApi;
import org.symphonyoss.symphony.pod.api.InfoBarriersApi;
import org.symphonyoss.symphony.pod.api.MessageSuppressionApi;
import org.symphonyoss.symphony.pod.api.PresenceApi;
import org.symphonyoss.symphony.pod.api.RoomMembershipApi;
import org.symphonyoss.symphony.pod.api.SecurityApi;
import org.symphonyoss.symphony.pod.api.SessionApi;
import org.symphonyoss.symphony.pod.api.StreamsApi;
import org.symphonyoss.symphony.pod.api.UserApi;
import org.symphonyoss.symphony.pod.api.UsersApi;
import org.symphonyoss.symphony.pod.invoker.Configuration;

public class SymphonyApisImpl
implements SymphonyApis {
    private final SymAuth symAuth;
    private org.symphonyoss.symphony.pod.invoker.ApiClient podApiClient;
    private ApiClient agentApiCient;
    private final Logger logger = LoggerFactory.getLogger(SymphonyApisImpl.class);

    public SymphonyApisImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null, null);
    }

    public SymphonyApisImpl(SymAuth symAuth, SymphonyClientConfig config, Client podHttpClient, Client agentHttpClient) {
        this.symAuth = symAuth;
        this.podApiClient = Configuration.getDefaultApiClient();
        if (podHttpClient != null) {
            this.podApiClient.setHttpClient(podHttpClient);
        }
        this.podApiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
        this.agentApiCient = org.symphonyoss.symphony.agent.invoker.Configuration.getDefaultApiClient();
        if (agentHttpClient != null) {
            this.agentApiCient.setHttpClient(agentHttpClient);
        }
        this.agentApiCient.setBasePath(config.get(SymphonyClientConfigID.AGENT_URL));
    }

    @Override
    public AttachmentsApi getAttachmentsApi() {
        return new AttachmentsApi(this.agentApiCient);
    }

    @Override
    public ConnectionApi getConnectionApi() {
        return new ConnectionApi(this.podApiClient);
    }

    @Override
    public DatafeedApi getDatafeedApi() {
        return new DatafeedApi(this.agentApiCient);
    }

    @Override
    public MessagesApi getMessagesApi() {
        return new MessagesApi(this.agentApiCient);
    }

    @Override
    public PresenceApi getPresenceApi() {
        return new PresenceApi(this.podApiClient);
    }

    @Override
    public RoomMembershipApi getRoomMembershipApi() {
        return new RoomMembershipApi(this.podApiClient);
    }

    @Override
    public StreamsApi getStreamsApi() {
        return new StreamsApi(this.podApiClient);
    }

    @Override
    public UsersApi getUsersApi() {
        return new UsersApi(this.podApiClient);
    }

    @Override
    public UserApi getUserApi() {
        return new UserApi(this.podApiClient);
    }

    @Override
    public ShareApi getShareApi() {
        return new ShareApi(this.agentApiCient);
    }

    @Override
    public org.symphonyoss.symphony.pod.api.SystemApi getPodSystemApi() {
        return new org.symphonyoss.symphony.pod.api.SystemApi(this.podApiClient);
    }

    @Override
    public SystemApi getAgentSystemApi() {
        return new SystemApi(this.agentApiCient);
    }

    @Override
    public AppEntitlementApi getAppEntitlementApi() {
        return new AppEntitlementApi(this.podApiClient);
    }

    @Override
    public ApplicationApi getApplicationApi() {
        return new ApplicationApi(this.podApiClient);
    }

    @Override
    public DisclaimerApi getDisclaimerApi() {
        return new DisclaimerApi(this.podApiClient);
    }

    @Override
    public InfoBarriersApi getInfoBarriersApi() {
        return new InfoBarriersApi(this.podApiClient);
    }

    @Override
    public MessageSuppressionApi getMessageSuppressionApi() {
        return new MessageSuppressionApi(this.podApiClient);
    }

    @Override
    public SecurityApi getSecurityApi() {
        return new SecurityApi(this.podApiClient);
    }

    @Override
    public SessionApi getSessionApi() {
        return new SessionApi(this.podApiClient);
    }
}

