/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.clients.impl;

import com.google.common.base.Strings;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.client.SymphonyClientConfig;
import org.symphonyoss.client.SymphonyClientConfigID;
import org.symphonyoss.client.exceptions.UserManagementClientException;
import org.symphonyoss.client.model.SymAuth;
import org.symphonyoss.symphony.authenticator.model.Token;
import org.symphonyoss.symphony.clients.UserManagementClient;
import org.symphonyoss.symphony.clients.model.SymFeatureList;
import org.symphonyoss.symphony.pod.api.UserApi;
import org.symphonyoss.symphony.pod.invoker.ApiClient;
import org.symphonyoss.symphony.pod.invoker.ApiException;
import org.symphonyoss.symphony.pod.invoker.Configuration;

public class UserManagementClientImpl
implements UserManagementClient {
    private static final Logger LOG = LoggerFactory.getLogger(UserManagementClientImpl.class);
    private static final String IS_EXTERNAL_ROOM_ENABLED = "isExternalRoomEnabled";
    private static final String IS_EXTERNAL_IM_ENABLED = "isExternalIMEnabled";
    private final SymAuth symAuth;
    private final ApiClient apiClient;

    public UserManagementClientImpl(SymAuth symAuth, SymphonyClientConfig config) {
        this(symAuth, config, null);
    }

    public UserManagementClientImpl(SymAuth symAuth, SymphonyClientConfig config, Client httpClient) {
        this.symAuth = symAuth;
        this.apiClient = Configuration.getDefaultApiClient();
        if (httpClient != null) {
            this.apiClient.setHttpClient(httpClient);
        }
        this.apiClient.setBasePath(config.get(SymphonyClientConfigID.POD_URL));
    }

    @Override
    public void updateExternalAccess(long userId, boolean allowExternalAccess) throws UserManagementClientException {
        SymFeatureList symFeatureList;
        UserApi userApi = new UserApi(this.apiClient);
        try {
            symFeatureList = SymFeatureList.toSymFeatureList(userApi.v1AdminUserUidFeaturesGet(this.getSessionToken(), Long.valueOf(userId)));
        }
        catch (ApiException e) {
            String errorMessage = "API Error communicating with POD while retrieving user features for user id " + userId;
            LOG.error(errorMessage, (Throwable)e);
            throw new UserManagementClientException(errorMessage, e.getCause());
        }
        SymFeatureList changedSymFeatureList = new SymFeatureList();
        symFeatureList.forEach(symFeature -> {
            boolean updateExternalAccess;
            boolean hasChanged = allowExternalAccess != symFeature.getEnabled();
            boolean updateExternalRoom = IS_EXTERNAL_ROOM_ENABLED.equals(symFeature.getEntitlement()) && hasChanged;
            boolean updateExternalIM = IS_EXTERNAL_IM_ENABLED.equals(symFeature.getEntitlement()) && hasChanged;
            boolean bl = updateExternalAccess = updateExternalRoom || updateExternalIM;
            if (updateExternalAccess) {
                symFeature.setEnabled(allowExternalAccess);
                changedSymFeatureList.add(symFeature);
                String externalAccessTypeMessage = updateExternalRoom ? "Room Chat access" : "Chat access";
                LOG.info("Setting External " + externalAccessTypeMessage + " to " + allowExternalAccess + " for user id " + userId);
            }
        });
        if (!changedSymFeatureList.isEmpty()) {
            try {
                userApi.v1AdminUserUidFeaturesUpdatePost(this.getSessionToken(), Long.valueOf(userId), SymFeatureList.toFeatureList(changedSymFeatureList));
            }
            catch (ApiException e) {
                String errorMessage = "API Error communicating with POD while updating user features for user id " + userId;
                LOG.error(errorMessage, (Throwable)e);
                throw new UserManagementClientException(errorMessage, e.getCause());
            }
        }
    }

    private String getSessionToken() {
        Token tokenObject = this.symAuth.getSessionToken();
        if (tokenObject == null) {
            throw new IllegalStateException("Invalid token object. It must not be null or empty");
        }
        String sessionToken = tokenObject.getToken();
        if (Strings.isNullOrEmpty((String)sessionToken)) {
            throw new IllegalStateException("Invalid session token. It must not be null or empty");
        }
        return sessionToken;
    }
}

